/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import java.util.ArrayList;
import java.util.List;

public abstract class StackTrace {
    public static String asString() {
        return StackTrace.asString(new Exception(), 1);
    }

    public static String asString(int nFramesToSkip) {
        return StackTrace.asString(new Exception(), "  [at ", "]", nFramesToSkip);
    }

    public static String asString(int nFramesToSkip, int count) {
        return StackTrace.asString(new Exception(), "  [at ", "]", nFramesToSkip, count);
    }

    public static List asList() {
        return StackTrace.asList(new Exception(), 1);
    }

    public static String asString(Throwable e) {
        return StackTrace.asString(e, 0);
    }

    public static final List asList(Throwable e) {
        return StackTrace.asList(e, 0);
    }

    public static String asString(Throwable e, int nFramesToIgnore) {
        return StackTrace.asString(e, "  [at ", "]", nFramesToIgnore);
    }

    private static List asList(Throwable e, int nFramesToIgnore) {
        StackTraceElement[] els = e.getStackTrace();
        ArrayList<String> aStack = new ArrayList<String>(els.length - nFramesToIgnore);
        int count = els.length;
        for (int at = nFramesToIgnore; at < count; ++at) {
            StackTraceElement el = els[at];
            aStack.add(el.toString());
        }
        return aStack;
    }

    public static String asString(Throwable e, String prefix, String postfix, int nFramesToIgnore) {
        return StackTrace.asString(e, prefix, postfix, nFramesToIgnore, Integer.MAX_VALUE);
    }

    public static String asString(Throwable e, String prefix, String postfix, int nFramesToIgnore, int count) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] els = e.getStackTrace();
        if (count > Integer.MAX_VALUE - nFramesToIgnore) {
            count = Integer.MAX_VALUE - nFramesToIgnore;
        }
        int end = Math.min(nFramesToIgnore + count, els.length);
        for (int at = nFramesToIgnore; at < end; ++at) {
            StackTraceElement el = els[at];
            if (at != nFramesToIgnore) {
                sb.append('\n');
            }
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(el.getClassName()).append('.').append(el.getMethodName());
            if (el.isNativeMethod()) {
                sb.append("(Native Method)");
            } else if (el.getFileName() != null) {
                sb.append('(');
                sb.append(el.getFileName());
                if (el.getLineNumber() >= 0) {
                    sb.append(':').append(el.getLineNumber());
                }
                sb.append(')');
            } else {
                sb.append("(Unknown Source)");
            }
            if (postfix == null) continue;
            sb.append(postfix);
        }
        return sb.toString();
    }
}

