/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class OutputUtils {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestamp(long timeStamp) {
        assert (timeStamp >= 0L);
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            return TIMESTAMP_FORMAT.format(new Date(timeStamp)) + " (" + timeStamp + ")";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDuration(long duration) {
        assert (duration >= 0L);
        if (duration < 1000L) {
            return duration + " milliseconds";
        }
        DecimalFormat decimalFormat = DECIMAL_FORMAT;
        synchronized (decimalFormat) {
            return DECIMAL_FORMAT.format((double)duration / 1000.0) + " seconds";
        }
    }

    public static String formatException(Throwable ex) {
        assert (ex != null);
        return ex.getClass().getName() + ": " + ex.getLocalizedMessage();
    }

    public static void dumpProperties(PrintStream out, Properties props) {
        assert (out != null);
        assert (props != null);
        TreeSet<String> set = new TreeSet<String>();
        Enumeration<Object> keysEnum = props.keys();
        while (keysEnum.hasMoreElements()) {
            String propertyName = (String)keysEnum.nextElement();
            set.add(propertyName + "=" + props.getProperty(propertyName));
        }
        Iterator i = set.iterator();
        while (i.hasNext()) {
            out.println(i.next());
        }
    }

    protected static final void dumpCollection(PrintStream out, String title, String prepend, Collection collection) {
        assert (out != null);
        assert (title != null);
        assert (prepend != null);
        assert (collection != null);
        out.println(title);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            out.println(prepend + it.next());
        }
    }
}

