/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.app;

import com.sun.org.apache.xalan.internal.xsltc.cmdline.getopt.GetOpt;
import com.tripwire.checker.accessor.AccessRunner;
import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.app.CommandLineListener;
import com.tripwire.checker.app.NullListener;
import com.tripwire.checker.app.PolicyTester;
import com.tripwire.checker.app.Test;
import com.tripwire.checker.app.TestResultType;
import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.PolicyTest;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.time.Time;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigChecker
implements Runnable,
ConfigCheckerListener {
    static final int VERBOSITY = Integer.getInteger("tw.honeybee.verbosity", 0);
    private HostCredentials m_hostCredentials;
    private String m_policyFile30;
    private String m_rulesFile30;
    private String m_rulesFile;
    private String m_policyFile35;
    private String m_rulesFile35;
    private String m_policyFileEmbedded;
    private int m_verbosity = VERBOSITY;
    private ConfigCheckerListener m_listener;
    private EsxServer.Version m_version;
    private String m_uname;
    private String m_vmware;
    private int m_maxTime = 600;
    private boolean m_done;

    public ConfigChecker(String host, String userid, String password, String rootPassword, ConfigCheckerListener listener, String policyFile30, String rulesFile30, String policyFile35, String rulesFile35, String policyFileEmbedded) {
        this.setHostCredentials(new HostCredentials(host, userid, password, rootPassword));
        this.setListener(listener);
        this.setPolicyFile30(policyFile30);
        this.setRulesFile30(rulesFile30);
        this.setPolicyFile35(policyFile35);
        this.setRulesFile35(rulesFile35);
        this.setRulesFile(rulesFile30);
        this.setPolicyFileEmbedded(policyFileEmbedded);
        this.setVersion(new EsxServer.Version());
    }

    public static void main(String[] args) {
        try {
            ConfigChecker spr = new ConfigChecker(args);
            if (spr.isValid()) {
                spr.setListener(new CommandLineListener());
                spr.run();
            } else if (spr.getPolicyFile30() != null) {
                spr.testPolicyOnly();
            } else {
                spr.usage();
            }
        }
        catch (Throwable t) {
            System.out.println("Throwable t=" + t);
            t.printStackTrace();
        }
    }

    public void testPolicyOnly() throws CheckerException {
        String policyFile = this.findPolicyFileName();
        PolicyTester policyTester = new PolicyTester(this);
        policyTester.loadContentTests(policyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setDone(false);
        if (this.getVerbosity() > 0) {
            System.out.println(this.getHostCredentials());
        }
        long startTime = Time.now();
        try {
            if (null == this.getHostCredentials() || !this.getHostCredentials().isValid()) {
                throw new CheckerException("tw.error.invalidHostCredentials");
            }
            ElementCache.getInstance().clear();
            PolicyTester policyTester = new PolicyTester(this);
            AccessRunner accessRunner = new AccessRunner();
            accessRunner.setListener(this);
            accessRunner.setHostCredentials(this.getHostCredentials());
            accessRunner.setPrintContent(this.getVerbosity() > 2);
            EsxServer.Version version = accessRunner.prepare();
            this.setVersion(version);
            this.onVersionInfo("", "", version);
            String policyFile = this.findPolicyFileName();
            accessRunner.setRulesFile(this.getRulesFile());
            this.onStart(policyFile);
            policyTester.loadContentTests(policyFile);
            Thread runThread = new Thread(accessRunner);
            runThread.start();
            int maxTime = this.getMaxTime();
            for (int ii = 0; !this.isDone() && ii < maxTime; ++ii) {
                try {
                    runThread.join(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.checkHostInfo();
                policyTester.verifyTests();
                if (!runThread.isAlive()) break;
            }
            if (this.getVerbosity() > 0) {
                System.out.println("\n");
            }
            if (!this.isDone() && runThread.isAlive()) {
                this.onFatalError(new CheckerException("tw.checker.app.accessorsTimedOut"));
            }
            policyTester.verifyTests();
            policyTester.printSummaryResults();
            if (this.getVerbosity() > 0) {
                System.out.println(this.getHostCredentials() + ";policy=" + policyFile);
            }
            policyTester.finalizeTestResults();
            policyTester.printSummaryResults();
            if (this.getVerbosity() > 3) {
                System.out.println(ElementCache.getInstance().getInfo(true, true));
            } else if (this.getVerbosity() > 2) {
                System.out.println(ElementCache.getInstance().getInfo(true, false));
            }
        }
        catch (CheckerException e) {
            if (this.m_verbosity > 2) {
                e.printStackTrace();
            }
            this.onFatalError(e);
        }
        finally {
            long endTime = Time.now();
            this.onEnd(endTime - startTime);
        }
    }

    private void checkHostInfo() {
        String curUname = ElementCache.getInstance().get("uname");
        String curVmware = ElementCache.getInstance().get("vmware");
        boolean doVersion = false;
        if (null != curUname && !curUname.equals(this.getUname())) {
            this.setUname(curUname);
            doVersion = true;
        } else if (null != curVmware && !curVmware.equals(this.getVmware())) {
            this.setVmware(curVmware);
            doVersion = true;
        }
        if (doVersion) {
            this.onVersionInfo(this.getUname(), this.getVmware(), this.getVersion());
        }
    }

    private String findPolicyFileName() throws CheckerException {
        String policyFile;
        EsxServer.Version version = this.getVersion();
        if (null == version) {
            policyFile = this.getPolicyFile30();
            this.setRulesFile(this.getRulesFile30());
        } else if (version.isProductLineEmbedded()) {
            policyFile = this.getPolicyFileEmbedded();
            this.setRulesFile(this.getRulesFile30());
        } else {
            String ver = version.getVersion();
            if (null != ver && ver.equals("3.5.0")) {
                policyFile = this.getPolicyFile35();
                this.setRulesFile(this.getRulesFile35());
            } else {
                policyFile = this.getPolicyFile30();
                this.setRulesFile(this.getRulesFile30());
            }
        }
        return policyFile;
    }

    public void usage() {
        System.out.println("Usage for ScratchPolicyRunner\n Host Access:\n    -h <hostfile>\n    -u <userid>\n    -p <password>\n    -r <rootPassword>\n Policy Run:\n    -f <policyFile30>\n    -5 <policyFile35>\n    -e <embeddedPolicyFile>\n    -F <rulesFile30>\n    -R <rulesFile35>\n Other:\n    -v \n\nExample:\n-h esx188.perf.tripwire.com -u mfriedman -pXXXXXXXXX -f \\\\mfriedmanxp\\share\\CIS_VMware_ESX_Server_v3_mjf.parser");
    }

    ConfigChecker(String[] args) {
        if (null == args) {
            this.usage();
            return;
        }
        this.setHostCredentials(new HostCredentials());
        GetOpt getOpt = new GetOpt(args, "e:f:F:h:p:R:r:u:v5:");
        getOpt.getCmdArgs();
        getOpt.printOptions();
        try {
            int curArg;
            block14: while ((curArg = getOpt.getNextOption()) != -1) {
                switch (curArg) {
                    case 101: {
                        this.setPolicyFileEmbedded(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 53: {
                        this.setPolicyFile35(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 102: {
                        this.setPolicyFile30(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 70: {
                        this.setRulesFile30(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 82: {
                        this.setRulesFile35(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 104: {
                        this.getHostCredentials().setHost(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 112: {
                        this.getHostCredentials().setPassword(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 114: {
                        this.getHostCredentials().setRootPassword(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 117: {
                        this.getHostCredentials().setUsername(getOpt.getOptionArg());
                        continue block14;
                    }
                    case 118: {
                        ++this.m_verbosity;
                        continue block14;
                    }
                }
                this.getHostCredentials().setHost(null);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return !(null == this.getHostCredentials() || !this.getHostCredentials().isValid() || this.getPolicyFile30() == null && this.getPolicyFile35() == null && this.getPolicyFileEmbedded() == null || this.getRulesFile30() == null && this.getRulesFile35() == null);
    }

    public HostCredentials getHostCredentials() {
        return this.m_hostCredentials;
    }

    public void setHostCredentials(HostCredentials hostCredentials) {
        this.m_hostCredentials = hostCredentials;
    }

    public String getPolicyFile30() {
        return this.m_policyFile30;
    }

    public void setPolicyFile30(String policyFile30) {
        this.m_policyFile30 = policyFile30;
    }

    public String getRulesFile30() {
        return this.m_rulesFile30;
    }

    public void setRulesFile30(String rulesFile30) {
        this.m_rulesFile30 = rulesFile30;
    }

    public String getPolicyFile35() {
        return this.m_policyFile35;
    }

    public void setPolicyFile35(String policyFile35) {
        this.m_policyFile35 = policyFile35;
    }

    public String getRulesFile35() {
        return this.m_rulesFile35;
    }

    public void setRulesFile35(String rulesFile35) {
        this.m_rulesFile35 = rulesFile35;
    }

    public ConfigCheckerListener getListener() {
        if (null == this.m_listener) {
            this.setListener(new NullListener());
        }
        return this.m_listener;
    }

    public void setListener(ConfigCheckerListener listener) {
        this.m_listener = listener;
    }

    public String getUname() {
        return this.m_uname;
    }

    public void setUname(String uname) {
        this.m_uname = uname;
    }

    public String getVmware() {
        return this.m_vmware;
    }

    public void setVmware(String vmware) {
        this.m_vmware = vmware;
    }

    public EsxServer.Version getVersion() {
        return this.m_version;
    }

    public void setVersion(EsxServer.Version version) {
        this.m_version = version;
    }

    public String getPolicyFileEmbedded() {
        return this.m_policyFileEmbedded;
    }

    public void setPolicyFileEmbedded(String policyFileEmbedded) {
        this.m_policyFileEmbedded = policyFileEmbedded;
    }

    public int getVerbosity() {
        return this.m_verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.m_verbosity = verbosity;
        System.setProperty("tw.honeybee.verbosity", "" + verbosity);
    }

    public int getMaxTime() {
        return this.m_maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.m_maxTime = maxTime;
    }

    public boolean isDone() {
        return this.m_done;
    }

    public void setDone(boolean done) {
        this.m_done = done;
    }

    @Override
    public void onStart(String policyFile) {
        this.getListener().onStart(policyFile);
    }

    @Override
    public void onTestsLoaded(HashMap<String, PolicyTest> tests) {
        this.getListener().onTestsLoaded(tests);
    }

    @Override
    public void onChangeTest(ContentTest test, TestResultType newResult, TestResultType oldResult) {
        if (this.isDone()) {
            return;
        }
        if (this.getVerbosity() > 1) {
            System.out.println("Changed Result: " + test.getAttribName() + "\n" + "\tElementName:" + test.getElementName() + "\tNewResult:" + newResult.getName() + "\tOldResult:" + oldResult.getName());
        }
        this.getListener().onChangeTest(test, newResult, oldResult);
    }

    @Override
    public void onTestError(Test test, CheckerException error) {
        this.getListener().onTestError(test, error);
    }

    @Override
    public void onFatalError(CheckerException error) {
        if (this.getVerbosity() > 1) {
            System.out.println("Fatal Error: addendum=" + error.getAddendum() + ";cause=" + error.getCause() + ";localizedMessage=" + error.getLocalizedMessage() + ";logMessage=" + error.getLogMessage() + ";message=" + error.getMessage());
        }
        this.setDone(true);
        this.getListener().onFatalError(error);
    }

    @Override
    public void onGeneralError(CheckerException error) {
        if (this.getVerbosity() > 1) {
            System.out.println("General Error: addendum=" + error.getAddendum() + ";cause=" + error.getCause() + ";localizedMessage=" + error.getLocalizedMessage() + ";logMessage=" + error.getLogMessage() + ";message=" + error.getMessage());
        }
        this.getListener().onGeneralError(error);
    }

    @Override
    public void onVersionInfo(String uname, String vmware, EsxServer.Version version) {
        if (this.getVerbosity() > 1) {
            System.out.println("Version: " + version);
        }
        this.getListener().onVersionInfo(uname, vmware, version);
    }

    @Override
    public void onAccessorStart(String accessorType) {
        this.getListener().onAccessorStart(accessorType);
    }

    @Override
    public void onAccessorChange(String accessorType, AccessorResultType newResult, AccessorResultType oldResult) {
        this.getListener().onAccessorChange(accessorType, newResult, oldResult);
    }

    @Override
    public void onAccessorEnd(String accessorType, long timeTaken, AccessorResultType result, Exception e) {
        this.getListener().onAccessorEnd(accessorType, timeTaken, result, e);
    }

    @Override
    public void onEnd(long timeTaken) {
        this.setDone(true);
        this.getListener().onEnd(timeTaken);
    }

    public String getRulesFile() {
        return this.m_rulesFile;
    }

    public void setRulesFile(String rulesFile) {
        this.m_rulesFile = rulesFile;
    }

    static {
        ResourceManager.getInstance().addStandardResources(ConfigChecker.class);
    }
}

