/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.BaseAccessor;
import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.xml.Param;
import com.tripwire.checker.app.xml.Rule;
import com.tripwire.checker.app.xml.Rules;
import com.tripwire.checker.app.xml.SshRule;
import com.tripwire.checker.app.xml.SshRules;
import com.tripwire.checker.app.xml.parser.SshRuleParser;
import com.tripwire.checker.app.xml.parser.SshRulesParser;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.common.util.ArrayUtil;
import com.tripwire.common.util.FileUtil;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.StreamUtil;
import com.tripwire.common.util.xml.AbstractXmlInputFormat;
import com.tripwire.common.util.xml.XmlDuplicateIdException;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.common.util.xml.XmlMissingTagException;
import com.tripwire.common.util.xml.XmlNoParserForElementException;
import com.tripwire.ipdevice.NetworkDeviceException;
import com.tripwire.ipdevice.SSHChannel;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.xml.GlobalXmlInputFormat;
import com.tripwire.vmware.api.HostCredentials;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshAccessor
extends BaseAccessor {
    public static final String ACCESSOR_NAME = "SSH";
    final int READ_TIMEOUT = 10;
    final int COMMAND_TIMEOUT = 500;
    private int totLines;
    private String m_rulesFile;
    private List<SshRule> m_sshRules;

    public SshAccessor(HostCredentials hostCredentials) throws CheckerException {
        this.setHostCredentials(hostCredentials);
    }

    @Override
    public String getName() {
        return ACCESSOR_NAME;
    }

    private Reader getReader(String filename) throws IOException {
        Reader reader;
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream(filename);
        if (null == in) {
            File file = new File(filename);
            reader = FileUtil.getUnicodeReader(file, true);
        } else {
            reader = FileUtil.getUnicodeReader(in, true);
        }
        return reader;
    }

    public static void install(AbstractXmlInputFormat mgr) {
        mgr.addParser(new SshRulesParser());
        mgr.addParser(new SshRuleParser());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRulesFile() throws CheckerException {
        Reader input;
        String filename = this.getRulesFile();
        if (null == filename) {
            return;
        }
        GlobalXmlInputFormat formats = GlobalXmlInputFormat.getInstance();
        try {
            input = this.getReader(filename);
        }
        catch (FileNotFoundException e) {
            throw new CheckerException(e, "tw.checker.app.loadRulesFile", ArrayUtil.EMPTY_OBJECTS);
        }
        catch (IOException e) {
            throw new CheckerException(e, "tw.checker.app.loadRulesFile", ArrayUtil.EMPTY_OBJECTS);
        }
        try {
            XmlInputContext context = new XmlInputContext(input, formats);
            while (context.detectElementStart()) {
                try {
                    Object sshRules;
                    Object o = context.maybeParseObjectElement();
                    if (o instanceof SshRules) {
                        sshRules = (SshRules)o;
                        this.setSshRules(((SshRules)sshRules).getSshRules());
                        continue;
                    }
                    if (!(o instanceof Rules)) continue;
                    sshRules = this.processRules(o);
                    this.setSshRules((List<SshRule>)sshRules);
                }
                catch (XmlNoParserForElementException e) {
                    throw new CheckerException(e, "tw.checker.app.unexpectedElementInRuleFile", null);
                    return;
                }
            }
        }
        catch (XmlMissingTagException e) {
            throw new CheckerException(e, "tw.checker.app.missingElementInRuleFile", null);
        }
        catch (XmlDuplicateIdException e) {
            throw new CheckerException(e, "tw.checker.app.duplicateElementInRuleFile", null);
        }
        catch (XmlException e) {
            throw new CheckerException(e, "tw.checker.app.parseRuleFile", null);
        }
        catch (IOException e) {
            throw new CheckerException(e, "tw.checker.app.readRuleFile", null);
        }
        finally {
            StreamUtil.close(input);
        }
    }

    private List<SshRule> processRules(Object o) {
        ArrayList<SshRule> sshRules = new ArrayList<SshRule>();
        Rules rules = (Rules)o;
        List<Rule> ruleList = rules.getRules();
        for (Rule curRule : ruleList) {
            String command = null;
            String elementName = null;
            String fileList = null;
            HashMap<String, Param> paramList = curRule.getParameters().getParams();
            if (null != paramList && !paramList.isEmpty()) {
                for (String key : paramList.keySet()) {
                    if (key.equals("command")) {
                        command = paramList.get(key).getContent();
                        continue;
                    }
                    if (key.equals("elementName")) {
                        elementName = paramList.get(key).getContent();
                        continue;
                    }
                    if (!key.equals("fileName")) continue;
                    fileList = paramList.get(key).getContent();
                }
            }
            if (null != command) {
                if (null != elementName) {
                    sshRules.add(new SshRule(elementName, command));
                    continue;
                }
                this.getListener().onFatalError(new CheckerException("tw.checker.app.cmdRuleMissingName", new Object[]{curRule.getAttribId() + " " + curRule.getAttribName()}));
                continue;
            }
            if (null != fileList) {
                String[] lines;
                for (String file : lines = fileList.split(" ")) {
                    command = "/bin/cat " + file;
                    elementName = file;
                    sshRules.add(new SshRule(elementName, command));
                }
                continue;
            }
            this.getListener().onFatalError(new CheckerException("tw.checker.app.problemWithRule", new Object[]{curRule.getAttribId() + " " + curRule.getAttribName()}));
        }
        return sshRules;
    }

    public void parseDirectory(String dirName, String dirContent) {
        StringBuilder buf = new StringBuilder();
        String[] lines = dirContent.split("\n");
        for (int ii = 0; ii < lines.length; ++ii) {
            String[] line;
            String curLine = lines[ii];
            if (ii < 3 && (curLine.startsWith("total") || curLine.endsWith(" ..") || curLine.endsWith(" .")) || (line = curLine.split(" +")).length < 8) continue;
            buf.delete(0, buf.length());
            boolean findPermissions = false;
            for (int jj = 0; jj < line.length; ++jj) {
                if (!findPermissions) {
                    String arg = line[jj];
                    if (null == arg || arg.length() != 10) continue;
                    char ch = arg.charAt(0);
                    switch (ch) {
                        case '-': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'l': 
                        case 'p': 
                        case 's': {
                            findPermissions = true;
                            buf.append(line[jj]);
                            buf.append(" ");
                            ++jj;
                            break;
                        }
                    }
                    continue;
                }
                buf.append(line[jj]);
                buf.append(" ");
            }
            if (!findPermissions) continue;
            String lastField = line[line.length - 1];
            if (buf.charAt(0) == 'l') {
                lastField = line[line.length - 3];
            }
            String elementName = lastField.startsWith("/") ? lastField + " permissions" : dirName + "/" + lastField + " permissions";
            ElementCache.getInstance().put(elementName, buf.toString());
        }
    }

    public String collectElements(SSHChannel channel, SshRule sshRule) throws IOException, SpaceException {
        StringBuilder fullOutput = new StringBuilder();
        channel.writeLine("TRIPWIRECONFIGCHECK", false);
        channel.setReadTimeout(15L);
        String[] output = channel.read();
        int outputLine = 0;
        StringBuilder buf = new StringBuilder();
        boolean started = false;
        int readCount = 1;
        String command = sshRule.getAttribCommand();
        String elementName = sshRule.getAttribName();
        channel.setReadTimeout(10L);
        while (readCount < 500) {
            if (outputLine >= output.length) {
                output = channel.read();
                outputLine = 0;
                ++readCount;
                if (outputLine >= output.length) continue;
            }
            fullOutput.append(output[outputLine]);
            if (!started) {
                if (output[outputLine].equals("START:" + elementName)) {
                    started = true;
                }
            } else {
                if (output[outputLine].endsWith("STOP:" + elementName)) {
                    int index = output[outputLine].indexOf("STOP:" + elementName);
                    if (index <= 0) break;
                    buf.append(output[outputLine], 0, index);
                    ++this.totLines;
                    buf.append("\n");
                    break;
                }
                buf.append(output[outputLine]);
                ++this.totLines;
                buf.append("\n");
            }
            ++outputLine;
        }
        if (!(buf.length() < command.length() + 40 && buf.toString().contains("No such file or directory") || buf.toString().contains("Is a directory"))) {
            if (command.startsWith("/bin/ls -la ")) {
                this.parseDirectory(elementName, buf.toString());
            } else if (command.startsWith("/bin/uname")) {
                if (buf.length() > 0 && buf.charAt(buf.length() - 1) == '\n') {
                    buf.deleteCharAt(buf.length() - 1);
                }
            } else if (command.startsWith("/usr/bin/vmware") && buf.length() > 0 && buf.charAt(buf.length() - 1) == '\n') {
                buf.deleteCharAt(buf.length() - 1);
            }
            ElementCache.getInstance().put(elementName, buf.toString());
        }
        return fullOutput.toString();
    }

    @Override
    public void access() throws Exception {
        this.processRulesFile();
        HostCredentials hostCredentials = this.getHostCredentials();
        String host = hostCredentials.getHost();
        String username = hostCredentials.getUsername();
        SSHChannel channel = new SSHChannel(host, username, hostCredentials.getPassword());
        try {
            boolean userIsRoot;
            channel.connect();
            List<SshRule> commands = this.getSshRules();
            boolean emptyRootPassword = hostCredentials.isRootPasswordEmpty();
            boolean bl = userIsRoot = null != hostCredentials.getUsername() && hostCredentials.getUsername().equals("root");
            if (!userIsRoot) {
                if (emptyRootPassword) {
                    this.getListener().onFatalError(new CheckerException("tw.error.missingRootLogin"));
                    return;
                }
                if (!this.suToRoot(channel)) {
                    return;
                }
            }
            this.verifyEsx(channel);
            for (SshRule sshRule : commands) {
                this.runRule(channel, sshRule);
            }
            if (!emptyRootPassword) {
                channel.writeLine("exit", false);
            }
        }
        catch (NetworkDeviceException e) {
            throw new CheckerException(e, "tw.checker.app.invalidSshConnection", null);
        }
        finally {
            channel.close();
        }
    }

    private String runRule(SSHChannel channel, SshRule sshRule) throws IOException, SpaceException {
        channel.writeLine("/bin/bash << \"TRIPWIRECONFIGCHECK\"", false);
        channel.writeLine("echo START:" + sshRule.getAttribName(), false);
        channel.writeLine(sshRule.getAttribCommand(), false);
        channel.writeLine("echo STOP:" + sshRule.getAttribName(), false);
        return this.collectElements(channel, sshRule);
    }

    private void verifyEsx(SSHChannel channel) throws IOException, InterruptedException, SpaceException {
        SshRule sshRule = new SshRule();
        sshRule.setAttribCommand("/usr/bin/vmware -v");
        sshRule.setAttribName("vmware");
        this.runRule(channel, sshRule);
        String vmware = ElementCache.getInstance().get("vmware");
        if (!vmware.startsWith("VMware ESX Server")) {
            throw new CheckerException("tw.checker.app.not.esx");
        }
    }

    private boolean suToRoot(SSHChannel channel) throws IOException, InterruptedException, SpaceException {
        String output;
        boolean success = true;
        StringBuilder buf = new StringBuilder();
        channel.writeLine("su -", false);
        Thread.sleep(1000L);
        channel.writeLine(this.getHostCredentials().getRootPassword(), false);
        channel.writeLine("\n", false);
        channel.writeLine("\n", false);
        Thread.sleep(1000L);
        SshRule sshRule = new SshRule();
        sshRule.setAttribCommand("/bin/echo init");
        sshRule.setAttribName("sshInit");
        for (int ii = 0; ii < 5; ++ii) {
            String fullOutput = this.runRule(channel, sshRule);
            buf.append(fullOutput);
            int checkLines = this.totLines;
            this.totLines = 0;
            if (1 == checkLines) break;
        }
        if ((output = buf.toString()).contains("incorrect password")) {
            this.getListener().onFatalError(new CheckerException("tw.error.invalidRootLogin"));
            success = false;
        }
        return success;
    }

    public String getRulesFile() {
        return this.m_rulesFile;
    }

    public void setRulesFile(String rulesFile) {
        this.m_rulesFile = rulesFile;
    }

    public List<SshRule> getSshRules() {
        return this.m_sshRules;
    }

    public void setSshRules(List<SshRule> sshRules) {
        this.m_sshRules = sshRules;
    }

    static {
        ResourceManager.getInstance().addStandardResources(SshAccessor.class);
    }
}

