/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.BaseAccessor;
import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.common.util.StreamUtil;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class ConfigBackupAccessor
extends BaseAccessor {
    public static final String ACCESSOR_NAME = "ConfigBackup";

    public ConfigBackupAccessor(HostCredentials hostCredentials) {
        this.setHostCredentials(hostCredentials);
    }

    public String getName() {
        return ACCESSOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() throws Exception {
        EsxServer server = new EsxServer(this.getHostCredentials());
        if (!server.getVersion().isProductLineEmbedded()) {
            this.setResult(AccessorResultType.UNAVAILABLE);
            return;
        }
        String strUrl = server.getConfigBackup();
        if (null != strUrl) {
            GZIPInputStream gzis = null;
            try {
                gzis = this.getZip(server, strUrl);
                this.processGzip(gzis);
            }
            catch (Throwable throwable) {
                StreamUtil.close(gzis);
                throw throwable;
            }
            StreamUtil.close(gzis);
        }
        server.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGzip(GZIPInputStream gzis) throws Exception {
        try {
            TarInputStream tin = new TarInputStream(gzis);
            TarEntry tarEntry = tin.getNextEntry();
            StringBuffer dir = new StringBuffer();
            while (tarEntry != null) {
                ByteArrayOutputStream baos;
                String elementName = tarEntry.getName();
                if (elementName.endsWith(".tgz")) {
                    baos = new ByteArrayOutputStream();
                    tin.copyEntryContents(baos);
                    ByteArrayInputStream bios = new ByteArrayInputStream(baos.toByteArray());
                    GZIPInputStream gzis2 = new GZIPInputStream(bios);
                    this.processGzip(gzis2);
                    tarEntry = tin.getNextEntry();
                    continue;
                }
                if (elementName.length() == 0 || elementName.charAt(0) != '/') {
                    elementName = '/' + elementName;
                }
                baos = new ByteArrayOutputStream();
                tin.copyEntryContents(baos);
                String fileContents = baos.toString();
                ElementCache.getInstance().put(elementName, fileContents);
                String attribs = this.convertMode(tarEntry);
                StringBuffer buf = this.buildFilePermissions(tarEntry, elementName, attribs);
                ElementCache.getInstance().put(elementName + " permissions", buf.toString());
                dir.append(buf);
                dir.append("\n");
                tarEntry = tin.getNextEntry();
            }
            tin.close();
            ElementCache.getInstance().put("ConfigBackupFiles", dir.toString());
        }
        finally {
            StreamUtil.close(gzis);
        }
    }
}

