/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

public final class PrimeSieve {
    public static final byte[] bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    int[] table;

    public PrimeSieve(int n) {
        if (n < 4) {
            n = 4;
        }
        int n2 = (n - 3) / 64;
        this.table = new int[n2];
        int n3 = n2 * 32;
        int n4 = (int)Math.sqrt(n3) + 1;
        for (int i = 0; i < n4; ++i) {
            if ((this.table[i / 32] & 1 << (i & 0x1F)) != 0) continue;
            int n5 = 3 + i * 2;
            for (int j = i + n5; j < n3; j += n5) {
                int n6 = j / 32;
                this.table[n6] = this.table[n6] | 1 << (j & 0x1F);
            }
        }
    }

    public int availablePrimes() {
        int n = 2;
        for (int i = 0; i < this.table.length; ++i) {
            int n2 = 0;
            for (int j = this.table[i]; j != 0; j >>>= 8) {
                n2 += bitCounts[j & 0xFF];
            }
            n += 32 - n2;
        }
        return n;
    }

    public int getNextPrime(int n) {
        int n2 = (n - 3) / 2 + 1;
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        while (n2 / 32 < this.table.length) {
            if ((this.table[n2 / 32] & 1 << (n2 & 0x1F)) == 0) {
                return n2 * 2 + 3;
            }
            ++n2;
        }
        return 0;
    }
}

