/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

public class FieldVideoAttributeMap {
    protected int defaultAttrib;
    protected int numAttribs;
    protected Attrib[] attribs;

    public FieldVideoAttributeMap(int n) {
        this.defaultAttrib = n;
        this.attribs = new Attrib[1];
    }

    public void setDefaultAttrib(int n) {
        this.defaultAttrib = n;
    }

    public boolean isAttrib(int n) {
        int n2 = this.getAttrib(n);
        if (n2 < 0) {
            return false;
        }
        Attrib attrib = this.attribs[n2];
        return attrib.getPos() == n;
    }

    public int get(int n) {
        int n2 = this.getAttrib(n);
        if (n2 < 0) {
            return this.defaultAttrib;
        }
        return this.attribs[n2].getAttrib();
    }

    public void set(int n, int n2) {
        int n3;
        if (this.numAttribs + 1 > this.attribs.length) {
            Attrib[] attribArray = new Attrib[this.attribs.length * 2 + 1];
            System.arraycopy(this.attribs, 0, attribArray, 0, this.attribs.length);
            this.attribs = attribArray;
        }
        if ((n3 = this.getAttrib(n)) >= 0 && this.attribs[n3].getPos() == n) {
            this.attribs[n3].setAttrib(n2);
        } else {
            Attrib attrib = new Attrib(n, n2);
            if (this.numAttribs == 0) {
                n3 = 0;
            } else {
                n3 = this.find(n);
                System.arraycopy(this.attribs, n3, this.attribs, n3 + 1, this.attribs.length - 1 - n3);
            }
            this.attribs[n3] = attrib;
            ++this.numAttribs;
        }
    }

    public void clearAt(int n) {
        if (!this.isAttrib(n)) {
            return;
        }
        int n2 = this.getAttrib(n);
        this.delete(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearFrom(int n) {
        int n2 = this.getAttrib(n);
        if (n2 < 0) {
            if (this.numAttribs <= 0) return;
            n2 = 0;
        } else if (this.attribs[n2].getPos() < n) {
            ++n2;
        }
        for (int i = this.numAttribs - 1; i >= n2; --i) {
            this.delete(n2);
        }
    }

    protected void delete(int n) {
        if (this.numAttribs == 1 || n + 1 == this.numAttribs) {
            --this.numAttribs;
        } else {
            System.arraycopy(this.attribs, n + 1, this.attribs, n, this.numAttribs - n - 1);
            --this.numAttribs;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertAt(int n) {
        int n2 = this.getAttrib(n);
        if (n2 < 0) {
            if (this.numAttribs <= 0) return;
            n2 = 0;
        } else if (this.attribs[n2].getPos() < n) {
            ++n2;
        }
        while (n2 < this.numAttribs) {
            this.attribs[n2].inc();
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAt(int n) {
        int n2 = this.getAttrib(n);
        if (n2 < 0) {
            if (this.numAttribs <= 0) return;
            n2 = 0;
        } else if (this.attribs[n2].getPos() < n) {
            ++n2;
        }
        while (n2 < this.numAttribs) {
            if (this.attribs[n2].getPos() == n) {
                this.delete(n2);
                for (int i = n2; i < this.numAttribs; ++i) {
                    this.attribs[i].dec();
                }
            } else {
                this.attribs[n2].dec();
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.numAttribs == 0) {
            stringBuffer.append("Empty");
        } else {
            for (int i = 0; i < this.numAttribs; ++i) {
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.attribs[i]);
            }
        }
        return stringBuffer.toString();
    }

    protected int getAttrib(int n) {
        if (this.numAttribs == 0) {
            return -1;
        }
        int n2 = this.find(n);
        if (n2 == this.numAttribs) {
            --n2;
        }
        if (this.attribs[n2].getPos() > n) {
            --n2;
        }
        return n2;
    }

    protected int find(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.numAttribs - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            n2 = this.attribs[n5].getPos() - n;
            if (n2 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 <= 0) break;
            n4 = n5 - 1;
        }
        n2 = n5;
        if (n3 > n5) {
            n2 = n3;
        }
        return n2;
    }

    protected class Attrib {
        private int pos;
        private int attrib;

        Attrib(int n, int n2) {
            this.pos = n;
            this.attrib = n2;
        }

        int getPos() {
            return this.pos;
        }

        void inc() {
            ++this.pos;
        }

        void dec() {
            --this.pos;
        }

        int getAttrib() {
            return this.attrib;
        }

        void setAttrib(int n) {
            this.attrib = n;
        }

        public String toString() {
            return String.valueOf(this.pos) + ": " + this.attrib;
        }
    }
}

