/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.DataType;
import com.mindbright.terminal.tandem6530.Field;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.Position;

public class FieldMap {
    protected int rows;
    protected int cols;
    protected Field[][] map;
    protected Position HOME;
    protected Position END;
    protected DataType dataTypeTable;
    protected boolean haveUnprotectedFields = false;

    public FieldMap(int n, int n2, FieldAttributes fieldAttributes, DataType dataType) {
        this.rows = n;
        this.cols = n2;
        this.dataTypeTable = dataType;
        this.HOME = new Position(0, 0);
        this.END = new Position(n - 1, n2 - 1);
        this.map = new Field[n][n2];
        Field field = new Field(n2, this.HOME, this.END, fieldAttributes, dataType);
        this.setField(this.HOME, this.END, field);
    }

    public void addField(Position position, FieldAttributes fieldAttributes) {
        Field field = this.getFieldAt(position);
        if (position.equals(field.getStart())) {
            field.redefine(fieldAttributes);
            return;
        }
        Position position2 = new Position(position);
        Field field2 = this.prevField(position);
        Field field3 = this.nextField(position);
        Position position3 = new Position(position).decCol(this.rows, this.cols);
        Position position4 = field3 == field ? new Position(this.END) : new Position(field3.getStart()).decCol(this.rows, this.cols);
        Field field4 = new Field(this.cols, position, position4, fieldAttributes, this.dataTypeTable);
        this.setField(field4.getStart(), field4.getEnd(), field4);
        this.adjustFields();
    }

    public void reset(FieldAttributes fieldAttributes) {
        Field field = new Field(this.cols, this.HOME, this.END, fieldAttributes, this.dataTypeTable);
        this.setField(this.HOME, this.END, field);
        this.adjustFields();
    }

    public boolean haveUnprotectedFields() {
        return this.haveUnprotectedFields;
    }

    protected void setField(Position position, Position position2, Field field) {
        Position position3 = new Position(position);
        this.setFieldAt(position3, field);
        while (!position3.equals(position2)) {
            position3.incCol(this.rows, this.cols);
            this.setFieldAt(position3, field);
        }
    }

    protected void setFieldAt(Position position, Field field) {
        this.map[position.getRow()][position.getCol()] = field;
    }

    public Field getFieldAt(Position position) {
        return this.map[position.getRow()][position.getCol()];
    }

    protected Position prevFieldEnd(Position position) {
        Field field = this.getFieldAt(position);
        Position position2 = new Position(position).decCol(this.rows, this.cols);
        while (field == this.getFieldAt(position2) && !position2.equals(this.HOME)) {
            position2.decCol(this.rows, this.cols);
        }
        return position2;
    }

    public Field prevField(Position position) {
        return this.getFieldAt(this.prevFieldEnd(position));
    }

    protected Position nextFieldStart(Position position) {
        Field field = this.getFieldAt(position);
        Position position2 = new Position(position).incCol(this.rows, this.cols);
        while (field == this.getFieldAt(position2) && !position2.equals(this.END)) {
            position2.incCol(this.rows, this.cols);
        }
        return position2;
    }

    public Field nextField(Position position) {
        return this.getFieldAt(this.nextFieldStart(position));
    }

    protected void adjustFields() {
        Position position = new Position(this.HOME);
        Position position2 = null;
        this.haveUnprotectedFields = false;
        while (!this.END.equals(position)) {
            position2 = this.nextFieldStart(position);
            if (!this.END.equals(position2)) {
                position2.decCol(this.rows, this.cols);
            }
            this.getFieldAt(position).setPosition(position, position2);
            if (!this.getFieldAt(position).isProtected()) {
                this.haveUnprotectedFields = true;
            }
            position = this.nextFieldStart(position);
        }
    }

    public void insertRow(int n) {
        Position position = new Position(n, 0);
        Field field = this.getFieldAt(position);
        if (position.equals(field.getStart())) {
            field = this.prevField(position);
        }
        System.arraycopy(this.map, n, this.map, n + 1, this.rows - n - 1);
        this.setField(position, new Position(n, this.cols - 1), field);
        this.adjustFields();
    }

    public void deleteRow(int n) {
        Field field = this.getFieldAt(this.END);
        System.arraycopy(this.map, n + 1, this.map, n, this.rows - n - 1);
        this.setField(new Position(this.rows - 1, 0), this.END, field);
        this.adjustFields();
    }

    protected void clearFields(Position position, Position position2) {
        Field field;
        if (this.HOME.equals(position)) {
            field = this.nextField(position2);
            if (this.getFieldAt(position) == field) {
                return;
            }
        } else {
            field = this.getFieldAt(position);
            if (field.getStart().equals(position)) {
                field = this.prevField(position);
            }
        }
        Position position3 = new Position(position);
        Position position4 = this.getFieldAt(position2).getEnd();
        block0: while (position3.le(position2)) {
            if (this.getFieldAt(position3).getStart().equals(position3)) {
                while (position3.le(position4)) {
                    this.setFieldAt(position3, field);
                    if (position3.equals(this.END)) break block0;
                    position3.incCol(this.rows, this.cols);
                }
                break;
            }
            position3.incCol(this.rows, this.cols);
        }
        this.adjustFields();
    }

    public void clear(Position position, Position position2) {
        this.clearFields(position, position2);
        Position position3 = new Position(position);
        while (!position3.equals(position2)) {
            this.getFieldAt(position3).clearAt(position3);
            position3.incCol(this.rows, this.cols);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Position position = new Position(this.HOME);
        Field field = null;
        int n = 0;
        while (!this.END.equals(position)) {
            field = this.getFieldAt(position);
            stringBuffer.append("Field ").append(n++).append(' ');
            stringBuffer.append(field.getStart()).append('-').append(field.getEnd());
            position = this.nextFieldStart(position);
        }
        return stringBuffer.toString();
    }
}

