/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.ParseException;
import java.util.Vector;

public class ConfigParameter {
    private char code;
    private int value = -1;
    private String strValue = null;

    public static ConfigParameter[] parse(String string) throws ParseException {
        Vector<ConfigParameter> vector = new Vector<ConfigParameter>();
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0) {
            vector.add(ConfigParameter.parseNextParam(stringBuffer));
        }
        ConfigParameter[] configParameterArray = new ConfigParameter[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            configParameterArray[i] = (ConfigParameter)vector.elementAt(i);
        }
        return configParameterArray;
    }

    private static ConfigParameter parseNextParam(StringBuffer stringBuffer) throws ParseException {
        ConfigParameter configParameter;
        char c = stringBuffer.charAt(0);
        if (!Character.isLetter(c)) {
            throw new ParseException("Missing code");
        }
        ConfigParameter.removeFirstChar(stringBuffer);
        if (stringBuffer.length() == 0) {
            throw new ParseException("Missing value");
        }
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == ' ') continue;
            if (!Character.isDigit(stringBuffer.charAt(i))) break;
            bl = true;
            break;
        }
        if (bl) {
            while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ' ') {
                ConfigParameter.removeFirstChar(stringBuffer);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            while (stringBuffer.length() > 0 && Character.isDigit(stringBuffer.charAt(0))) {
                stringBuffer2.append(ConfigParameter.removeFirstChar(stringBuffer));
            }
            int n = 0;
            try {
                n = Integer.parseInt(stringBuffer2.toString(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Value must be a number");
            }
            configParameter = new ConfigParameter(c, n);
            while (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ' ') {
                ConfigParameter.removeFirstChar(stringBuffer);
            }
        } else {
            configParameter = new ConfigParameter(c, stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return configParameter;
    }

    private static char removeFirstChar(StringBuffer stringBuffer) {
        char c = stringBuffer.charAt(0);
        stringBuffer.reverse();
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.reverse();
        return c;
    }

    public ConfigParameter(char c, int n) {
        this.code = c;
        this.value = n;
    }

    public ConfigParameter(char c, String string) {
        this.code = c;
        this.strValue = string;
    }

    public char getCode() {
        return this.code;
    }

    public int getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.strValue;
    }

    public boolean hasStringValue() {
        return this.strValue != null;
    }

    public String toString() {
        if (this.hasStringValue()) {
            return this.code + " " + this.strValue;
        }
        return this.code + " " + String.valueOf(this.value);
    }
}

