/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.filter;

import com.mindbright.terminal.CharsetFilter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class Filter
implements CharsetFilter {
    static final boolean DEBUG = false;
    CharsetEncoder encoder;
    CharsetDecoder decoder;
    ByteBuffer decode_in;
    CharBuffer decode_out;
    CharBuffer encode_in;
    ByteBuffer encode_out;

    private Filter(String string) {
        Charset charset = Charset.forName(string);
        this.encoder = charset.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder = charset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decode_in = ByteBuffer.allocate(16);
        this.decode_out = CharBuffer.allocate(16);
        this.encode_in = CharBuffer.allocate(16);
        this.encode_out = ByteBuffer.allocate(16);
    }

    public static Filter create(String string) {
        try {
            return new Filter(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return null;
        }
    }

    private String intConvertFrom(ByteBuffer byteBuffer) {
        CoderResult coderResult;
        String string = null;
        ((Buffer)byteBuffer).flip();
        do {
            ((Buffer)this.decode_out).clear();
            coderResult = this.decoder.decode(byteBuffer, this.decode_out, false);
            ((Buffer)this.decode_out).flip();
            string = string == null ? this.decode_out.toString() : string + this.decode_out.toString();
        } while (coderResult == CoderResult.OVERFLOW);
        byteBuffer.compact();
        return string;
    }

    private void prepareDecodeIn(int n) {
        if (this.decode_in.capacity() - this.decode_in.position() < n) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.decode_in.capacity() + n);
            ((Buffer)this.decode_in).flip();
            while (this.decode_in.hasRemaining()) {
                byteBuffer.put(this.decode_in.get());
            }
            this.decode_in = byteBuffer;
        }
    }

    public String convertFrom(byte by) {
        this.prepareDecodeIn(1);
        this.decode_in.put(by);
        return this.intConvertFrom(this.decode_in);
    }

    public String convertFrom(byte[] byArray, int n, int n2) {
        this.prepareDecodeIn(n2 * 2);
        this.decode_in.put(byArray, n, n2);
        return this.intConvertFrom(this.decode_in);
    }

    private byte[] intConvertTo(CharBuffer charBuffer) {
        CoderResult coderResult;
        ((Buffer)charBuffer).flip();
        byte[] byArray = null;
        do {
            ((Buffer)this.encode_out).clear();
            coderResult = this.encoder.encode(charBuffer, this.encode_out, false);
            if (byArray == null) {
                byArray = new byte[this.encode_out.position()];
                ((Buffer)this.encode_out).rewind();
                this.encode_out.get(byArray);
                continue;
            }
            byte[] byArray2 = new byte[byArray.length + this.encode_out.position()];
            ((Buffer)this.encode_out).rewind();
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.encode_out.get(byArray2, byArray.length, this.encode_out.limit());
            byArray = byArray2;
        } while (coderResult == CoderResult.OVERFLOW);
        return byArray;
    }

    public byte[] convertTo(char c) {
        ((Buffer)this.encode_in).clear();
        this.encode_in.put(c);
        return this.intConvertTo(this.encode_in);
    }

    public byte[] convertTo(byte[] byArray) {
        if (this.encode_in.capacity() < byArray.length) {
            this.encode_in = CharBuffer.allocate(byArray.length);
        } else {
            ((Buffer)this.encode_in).clear();
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.encode_in.put((char)byArray[i]);
        }
        return this.intConvertTo(this.encode_in);
    }
}

