/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2StreamChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class SSH2TCPChannel
extends SSH2StreamChannel {
    protected Socket endpoint;
    protected String originAddr;
    protected int originPort;
    protected String remoteAddr;
    protected int remotePort;

    public SSH2TCPChannel(int n, SSH2Connection sSH2Connection, Object object, Socket socket, String string, int n2, String string2, int n3) throws IOException {
        super(n, sSH2Connection, object, socket.getInputStream(), socket.getOutputStream());
        this.endpoint = socket;
        this.remoteAddr = string;
        this.remotePort = n2;
        this.originAddr = string2;
        this.originPort = n3;
    }

    protected void outputClosed() {
        if (this.endpoint != null) {
            try {
                this.endpoint.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.endpoint = null;
    }

    protected boolean openFailureImpl(int n, String string, String string2) {
        this.outputClosed();
        return false;
    }

    public InetAddress getAddress() {
        return this.endpoint.getInetAddress();
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public String getRemoteAddress() {
        return this.remoteAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getOriginAddress() {
        return this.originAddr;
    }

    public int getOriginPort() {
        return this.originPort;
    }

    public String toString() {
        String string = "<N/A>";
        switch (this.channelType) {
            case 0: {
                string = "[remote] " + this.originAddr + ":" + this.originPort + " <--> " + this.getRemoteAddress() + ":" + this.getRemotePort() + " <--ssh2--> " + this.getAddress().getHostAddress() + ":" + this.getPort();
                break;
            }
            case 1: {
                SSH2Listener sSH2Listener = (SSH2Listener)this.creator;
                string = "[local] " + this.originAddr + ":" + this.originPort + " <--> " + sSH2Listener.getListenHost() + ":" + sSH2Listener.getListenPort() + " <--ssh2--> " + this.getRemoteAddress() + ":" + this.getRemotePort();
                break;
            }
            default: {
                System.out.println("!!! NOT SUPPORTED IN SSH2TCPChannel.toString !!!");
            }
        }
        return string;
    }
}

