/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2StreamChannel;
import com.mindbright.ssh2.SSH2StreamFilter;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import com.mindbright.util.HexDump;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2StreamSniffer
implements SSH2StreamFilter,
SSH2StreamFilterFactory {
    protected int id;
    private static SSH2StreamSniffer factoryInstance;

    private SSH2StreamSniffer() {
    }

    public static synchronized SSH2StreamSniffer getFilterFactory() {
        if (factoryInstance == null) {
            factoryInstance = new SSH2StreamSniffer();
        }
        return factoryInstance;
    }

    public SSH2StreamFilter createFilter(SSH2Connection sSH2Connection, SSH2StreamChannel sSH2StreamChannel) {
        SSH2StreamSniffer sSH2StreamSniffer = new SSH2StreamSniffer();
        sSH2StreamSniffer.id = sSH2StreamChannel.getChannelId();
        return sSH2StreamSniffer;
    }

    public InputStream getInputFilter(InputStream inputStream) {
        return new SniffInput(inputStream);
    }

    public OutputStream getOutputFilter(OutputStream outputStream) {
        return new SniffOutput(outputStream);
    }

    protected class SniffInput
    extends FilterInputStream {
        public SniffInput(InputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 >= 0) {
                HexDump.print("ch. #" + SSH2StreamSniffer.this.id + " rx:", true, byArray, n, n3);
            } else {
                System.out.println("ch. #" + SSH2StreamSniffer.this.id + " rx: EOF");
            }
            return n3;
        }
    }

    protected class SniffOutput
    extends FilterOutputStream {
        public SniffOutput(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            HexDump.print("ch. #" + SSH2StreamSniffer.this.id + " tx:", true, byArray, n, n2);
            this.out.write(byArray, n, n2);
        }
    }
}

