/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2HostKeyVerifier;
import com.mindbright.ssh2.SSH2Signature;
import com.mindbright.ssh2.SSH2SimpleSignature;
import com.mindbright.util.ASCIIArmour;
import com.mindbright.util.Base64;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SSH2PublicKeyFile {
    public static final String BEGIN_PUB_KEY = "---- BEGIN SSH2 PUBLIC KEY ----";
    public static final String END_PUB_KEY = "---- END SSH2 PUBLIC KEY ----";
    private PublicKey publicKey;
    private String subject;
    private String comment;
    private boolean sshComFormat;
    public static final String FILE_SUBJECT = "Subject";
    public static final String FILE_COMMENT = "Comment";

    public SSH2PublicKeyFile(PublicKey publicKey, String string, String string2) {
        this.publicKey = publicKey;
        this.subject = string;
        this.comment = string2;
    }

    public SSH2PublicKeyFile() {
        this(null, null, null);
    }

    public String getAlgorithmName() {
        String string = null;
        if (this.publicKey instanceof DSAPublicKey) {
            string = "ssh-dss";
        } else if (this.publicKey instanceof RSAPublicKey) {
            string = "ssh-rsa";
        }
        return string;
    }

    public boolean isSSHComFormat() {
        return this.sshComFormat;
    }

    public void load(String string) throws IOException, SSH2Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public void load(InputStream inputStream) throws IOException, SSH2Exception {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        pushbackInputStream.unread(n);
        byte[] byArray = null;
        String string = null;
        if (n == 115) {
            int n2;
            int n3 = pushbackInputStream.available();
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n3; i += n2) {
                n2 = pushbackInputStream.read(byArray2, i, n3 - i);
                if (n2 != -1) continue;
                throw new SSH2FatalException("Corrupt public key file");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray2));
            String string2 = null;
            try {
                string = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                this.comment = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SSH2FatalException("Corrupt openssh public key string");
            }
            byArray = Base64.decode(string2.getBytes());
        } else if (n == 45) {
            ASCIIArmour aSCIIArmour = new ASCIIArmour(BEGIN_PUB_KEY, END_PUB_KEY);
            byArray = aSCIIArmour.decode(pushbackInputStream);
            string = SSH2SimpleSignature.getKeyFormat(byArray);
            this.subject = aSCIIArmour.getHeaderField(FILE_SUBJECT);
            this.comment = this.stripQuotes(aSCIIArmour.getHeaderField(FILE_COMMENT));
            this.sshComFormat = true;
        } else {
            throw new SSH2FatalException("Corrupt or unknown public key file format");
        }
        SSH2Signature sSH2Signature = SSH2Signature.getEncodingInstance(string);
        this.publicKey = sSH2Signature.decodePublicKey(byArray);
    }

    public String store(String string) throws IOException, SSH2Exception {
        return this.store(string, this.sshComFormat);
    }

    public String store(String string, boolean bl) throws IOException, SSH2Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        String string2 = this.store(bl);
        fileOutputStream.write(string2.getBytes());
        fileOutputStream.close();
        return string2;
    }

    public String store(boolean bl) throws SSH2Exception {
        String string = this.getAlgorithmName();
        if (string == null) {
            throw new SSH2FatalException("Unknown publickey alg: " + this.publicKey);
        }
        byte[] byArray = this.getRaw();
        String string2 = null;
        if (bl) {
            ASCIIArmour aSCIIArmour = new ASCIIArmour(BEGIN_PUB_KEY, END_PUB_KEY);
            aSCIIArmour.setCanonicalLineEnd(false);
            aSCIIArmour.setHeaderField(FILE_SUBJECT, this.subject);
            aSCIIArmour.setHeaderField(FILE_COMMENT, "\"" + this.comment + "\"");
            string2 = new String(aSCIIArmour.encode(byArray));
        } else {
            byte[] byArray2 = Base64.encode(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(new String(byArray2));
            stringBuffer.append(" ");
            stringBuffer.append(this.comment);
            stringBuffer.append("\n");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getRaw() throws SSH2Exception {
        SSH2Signature sSH2Signature = SSH2Signature.getEncodingInstance(this.getAlgorithmName());
        return sSH2Signature.encodePublicKey(this.publicKey);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public boolean sameAs(PublicKey publicKey) {
        return SSH2HostKeyVerifier.comparePublicKeys(this.publicKey, publicKey);
    }

    private String stripQuotes(String string) throws SSH2FatalException {
        if (string != null && string.charAt(0) == '\"') {
            if (string.charAt(string.length() - 1) != '\"') {
                throw new SSH2FatalException("Unbalanced quotes in key file comment");
            }
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }
}

