/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2KEXFailedException;
import com.mindbright.ssh2.SSH2KeyExchanger;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2TransportPDU;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SSH2Preferences {
    public static final String PKG_VERSION = "package-version";
    public static final String KEX_ALGORITHMS = "kex-algorithms";
    public static final String HOST_KEY_ALG = "server-host-key-algorithms";
    public static final String CIPHERS_C2S = "enc-algorithms-cli2srv";
    public static final String CIPHERS_S2C = "enc-algorithms-srv2cli";
    public static final String MACS_C2S = "mac-algorithms-cli2srv";
    public static final String MACS_S2C = "mac-algorithms-srv2cli";
    public static final String COMP_C2S = "comp-algorithms-cli2srv";
    public static final String COMP_S2C = "comp-algorithms-srv2cli";
    public static final String LANG_C2S = "languages-cli2srv";
    public static final String LANG_S2C = "languages-srv2cli";
    public static final String COMP_LEVEL = "compression";
    public static final String ALIVE = "alive";
    public static final String RX_INIT_WIN_SZ = "rx-init-win-sz";
    public static final String RX_MAX_PKT_SZ = "rx-max-pkt-sz";
    public static final String TX_MAX_PKT_SZ = "tx-max-pkt-sz";
    public static final String X11_DISPLAY = "x11-display";
    public static final String QUEUED_RX_CHAN = "queued-rx-chan";
    public static final String DEFAULT_PKT_SZ = "default-pkt-sz";
    public static final String PKT_POOL_SZ = "pkt-pool-sz";
    public static final String TERM_MIN_LAT = "term-min-lat";
    public static final String INT_IO_BUF_SZ = "int-io-buf-sz";
    public static final String QUEUE_DEPTH = "queue-depth";
    public static final String QUEUE_HIWATER = "queue-hiwater";
    public static final String LOG_LEVEL = "log-level";
    public static final String LOG_FILE = "log-file";
    public static final String LOG_APPEND = "log-append";
    public static final String SOCK_OPT = "socketoption.";
    public static final String SOCK_OPT_TRANSPORT = "transport";
    public static final String SOCK_OPT_LOCAL = "local.";
    public static final String SOCK_OPT_REMOTE = "remote.";
    public static final String SO_TCP_NODELAY = "tcp-nodelay";
    static final String[] kexFields = new String[]{"kex-algorithms", "server-host-key-algorithms", "enc-algorithms-cli2srv", "enc-algorithms-srv2cli", "mac-algorithms-cli2srv", "mac-algorithms-srv2cli", "comp-algorithms-cli2srv", "comp-algorithms-srv2cli", "languages-cli2srv", "languages-srv2cli"};
    static final String[][] ciphers = new String[][]{{"3des-cbc", "3DES/CBC"}, {"3des-ecb", "3DES/ECB"}, {"3des-cfb", "3DES/CFB"}, {"3des-ofb", "3DES/OFB"}, {"3des-ctr", "3DES/CTR"}, {"blowfish-cbc", "Blowfish/CBC"}, {"blowfish-ecb", "Blowfish/ECB"}, {"blowfish-cfb", "Blowfish/CFB"}, {"blowfish-ofb", "Blowfish/OFB"}, {"blowfish-ctr", "Blowfish/CTR"}, {"aes128-cbc", "AES/CBC"}, {"aes192-cbc", "AES/CBC"}, {"aes256-cbc", "AES/CBC"}, {"aes128-ctr", "AES/CTR"}, {"aes192-ctr", "AES/CTR"}, {"aes256-ctr", "AES/CTR"}, {"rijndael128-cbc", "Rijndael/CBC"}, {"rijndael192-cbc", "Rijndael/CBC"}, {"rijndael256-cbc", "Rijndael/CBC"}, {"twofish128-ctr", "Twofish/CTR"}, {"twofish128-cbc", "Twofish/CBC"}, {"twofish192-ctr", "Twofish/CTR"}, {"twofish192-cbc", "Twofish/CBC"}, {"twofish256-ctr", "Twofish/CTR"}, {"twofish256-cbc", "Twofish/CBC"}, {"twofish-cbc", "Twofish/CBC"}, {"twofish-ecb", "Twofish/ECB"}, {"twofish-cfb", "Twofish/CFB"}, {"twofish-ofb", "Twofish/OFB"}, {"cast128-cbc", "CAST128/CBC"}, {"cast128-ecb", "CAST128/ECB"}, {"cast128-cfb", "CAST128/CFB"}, {"cast128-ofb", "CAST128/OFB"}, {"idea-cbc", "IDEA/CBC"}, {"idea-ecb", "IDEA/ECB"}, {"idea-cfb", "IDEA/CFB"}, {"idea-ofb", "IDEA/OFB"}, {"arcfour", "RC4/OFB"}, {"arcfour128", "RC4Skip/OFB"}, {"arcfour256", "RC4Skip/OFB"}};
    static final String[][] macs = new String[][]{{"hmac-sha1", "HmacSHA1"}, {"hmac-md5", "HmacMD5"}, {"hmac-ripemd160", "HmacRIPEMD160"}, {"hmac-sha1-96", "HmacSHA1-96"}, {"hmac-md5-96", "HmacMD5-96"}, {"hmac-ripemd160-96", "HmacRIPEMD160-96"}, {"hmac-ripemd160@openssh.com", "HmacRIPEMD160"}};
    private static final Properties defaultProperties = new Properties();
    private Properties preferences = new Properties(defaultProperties);
    private Hashtable kexAgreedAlgs = new Hashtable();
    private boolean sameKEXGuess;
    private boolean haveAgreed;
    private String disagreeType;

    public SSH2Preferences() {
    }

    public SSH2Preferences(Properties properties) {
        this();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            ((Hashtable)this.preferences).put(string, string2);
        }
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public void readFrom(SSH2TransportPDU sSH2TransportPDU) {
        for (int i = 0; i < 10; ++i) {
            this.setPreference(kexFields[i], sSH2TransportPDU.readJavaString());
        }
    }

    public void writeTo(SSH2TransportPDU sSH2TransportPDU) {
        for (int i = 0; i < 10; ++i) {
            sSH2TransportPDU.writeString(this.getPreference(kexFields[i]));
        }
    }

    public String getPreference(String string) {
        return this.preferences.getProperty(string);
    }

    public int getIntPreference(String string) {
        try {
            return Integer.parseInt(this.getPreference(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Illegal value of '" + string + "' expected integer but got '" + this.getPreference(string) + "'");
        }
    }

    public boolean getBooleanPreference(String string) {
        return Boolean.valueOf(this.getPreference(string));
    }

    public void setPreference(String string, String string2) {
        ((Hashtable)this.preferences).put(string, string2);
    }

    public String getAgreedKEXAlgorithm() {
        return (String)this.kexAgreedAlgs.get(KEX_ALGORITHMS);
    }

    public String getAgreedHostKeyAlgorithm() {
        return (String)this.kexAgreedAlgs.get(HOST_KEY_ALG);
    }

    public String getAgreedCipher(boolean bl, boolean bl2) {
        String string = bl ^ bl2 ? CIPHERS_C2S : CIPHERS_S2C;
        return (String)this.kexAgreedAlgs.get(string);
    }

    public String getAgreedMac(boolean bl, boolean bl2) {
        String string = bl ^ bl2 ? MACS_C2S : MACS_S2C;
        return (String)this.kexAgreedAlgs.get(string);
    }

    public String getAgreedCompression(boolean bl, boolean bl2) {
        String string = bl ^ bl2 ? COMP_C2S : COMP_S2C;
        return (String)this.kexAgreedAlgs.get(string);
    }

    public boolean isSupported(String string, String string2) {
        String string3 = this.getPreference(string);
        return SSH2ListUtil.isInList(string3, string2);
    }

    public SSH2KeyExchanger selectKEXAlgorithm(SSH2Preferences sSH2Preferences, boolean bl) throws SSH2KEXFailedException {
        String string;
        String string2;
        String string3;
        String string4;
        SSH2KeyExchanger sSH2KeyExchanger = null;
        if (bl) {
            string4 = sSH2Preferences.getPreference(KEX_ALGORITHMS);
            string3 = this.getPreference(KEX_ALGORITHMS);
            string2 = sSH2Preferences.getPreference(HOST_KEY_ALG);
            string = this.getPreference(HOST_KEY_ALG);
        } else {
            string4 = this.getPreference(KEX_ALGORITHMS);
            string3 = sSH2Preferences.getPreference(KEX_ALGORITHMS);
            string2 = this.getPreference(HOST_KEY_ALG);
            string = sSH2Preferences.getPreference(HOST_KEY_ALG);
        }
        String string5 = SSH2ListUtil.getFirstInList(string4);
        String string6 = null;
        while (string5 != null && (string6 = this.chooseHostKeyAlgorithm(string2, string, (sSH2KeyExchanger = SSH2KeyExchanger.getInstance(string5)).getHostKeyAlgorithms())) == null) {
            string4 = SSH2ListUtil.removeFirstFromList(string4, string5);
            string5 = SSH2ListUtil.getFirstInList(string4);
        }
        if (string5 == null) {
            String string7 = "Couldn't agree on kex algorithm (our: '" + this.getPreference(KEX_ALGORITHMS) + "', peer: '" + sSH2Preferences.getPreference(KEX_ALGORITHMS) + "')";
            throw new SSH2KEXFailedException(string7);
        }
        this.sameKEXGuess = string5.equals(SSH2ListUtil.getFirstInList(string3)) && string6.equals(SSH2ListUtil.getFirstInList(string));
        this.kexAgreedAlgs.put(KEX_ALGORITHMS, string5);
        this.kexAgreedAlgs.put(HOST_KEY_ALG, string6);
        return sSH2KeyExchanger;
    }

    public boolean sameKEXGuess() {
        return this.sameKEXGuess;
    }

    public boolean canAgree(SSH2Preferences sSH2Preferences, boolean bl) {
        this.haveAgreed = true;
        for (int i = 2; i < 8; ++i) {
            String string = kexFields[i];
            String string2 = this.choosePref(string, sSH2Preferences, bl);
            if (string2 == null) {
                this.haveAgreed = false;
                this.sameKEXGuess = false;
                this.disagreeType = string;
                break;
            }
            this.kexAgreedAlgs.put(string, string2);
        }
        return this.haveAgreed;
    }

    public String getDisagreeType() {
        return this.disagreeType;
    }

    private String chooseHostKeyAlgorithm(String string, String string2, String string3) {
        String string4 = SSH2ListUtil.chooseFromList(string, string3);
        while (string4 != null && !SSH2ListUtil.isInList(string2, string4)) {
            string = SSH2ListUtil.removeFirstFromList(string, string4);
            string4 = SSH2ListUtil.chooseFromList(string, string3);
        }
        return string4;
    }

    private String choosePref(String string, SSH2Preferences sSH2Preferences, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = sSH2Preferences.getPreference(string);
            string2 = this.getPreference(string);
        } else {
            string3 = this.getPreference(string);
            string2 = sSH2Preferences.getPreference(string);
        }
        return SSH2ListUtil.chooseFromList(string3, string2);
    }

    public static String ssh2ToJCECipher(String string) {
        for (int i = 0; i < ciphers.length; ++i) {
            if (!ciphers[i][0].equals(string)) continue;
            return ciphers[i][1];
        }
        return null;
    }

    public static String ssh2ToJCEMac(String string) {
        for (int i = 0; i < macs.length; ++i) {
            if (!macs[i][0].startsWith(string)) continue;
            return macs[i][1];
        }
        return null;
    }

    public static int getCipherKeyLen(String string) {
        int n = 128;
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf("128") != -1) {
                n = 128;
            } else if (string.indexOf("192") != -1) {
                n = 192;
            } else if (string.indexOf("256") != -1) {
                n = 256;
            } else if (string.startsWith("twofish") || string.startsWith("rijndael") || string.startsWith("aes")) {
                n = 256;
            } else if (string.startsWith("3des")) {
                n = 192;
            }
        }
        return n / 8;
    }

    public static int getMacKeyLen(String string) {
        int n = 16;
        if (string != null && (string.indexOf("SHA") != -1 || string.indexOf("sha") != -1 || string.indexOf("ripemd160") != -1)) {
            n = 20;
        }
        return n;
    }

    static {
        String string = "aes128-ctr,aes128-cbc,blowfish-ctr,blowfish-cbc,aes192-ctr,aes192-cbcaes256-ctr,aes256-cbc,3des-cre,3des-cbc,arcfour";
        ((Hashtable)defaultProperties).put(KEX_ALGORITHMS, "diffie-hellman-group1-sha1,diffie-hellman-group1-sha14,diffie-hellman-group-exchange-sha1");
        ((Hashtable)defaultProperties).put(HOST_KEY_ALG, "ssh-dss,ssh-rsa");
        ((Hashtable)defaultProperties).put(CIPHERS_C2S, string);
        ((Hashtable)defaultProperties).put(CIPHERS_S2C, string);
        ((Hashtable)defaultProperties).put(MACS_C2S, "hmac-md5,hmac-sha1");
        ((Hashtable)defaultProperties).put(MACS_S2C, "hmac-md5,hmac-sha1");
        ((Hashtable)defaultProperties).put(COMP_C2S, "none,zlib,zlib@openssh.com");
        ((Hashtable)defaultProperties).put(COMP_S2C, "none,zlib,zlib@openssh.com");
        ((Hashtable)defaultProperties).put(LANG_C2S, "");
        ((Hashtable)defaultProperties).put(LANG_S2C, "");
        ((Hashtable)defaultProperties).put(RX_INIT_WIN_SZ, "32768");
        ((Hashtable)defaultProperties).put(RX_MAX_PKT_SZ, "8192");
        ((Hashtable)defaultProperties).put(TX_MAX_PKT_SZ, "8192");
        ((Hashtable)defaultProperties).put(X11_DISPLAY, "127.0.0.1:0");
        ((Hashtable)defaultProperties).put(QUEUED_RX_CHAN, "true");
        ((Hashtable)defaultProperties).put(DEFAULT_PKT_SZ, "8192");
        ((Hashtable)defaultProperties).put(PKT_POOL_SZ, "64");
        ((Hashtable)defaultProperties).put(TERM_MIN_LAT, "false");
        ((Hashtable)defaultProperties).put(INT_IO_BUF_SZ, "65536");
        ((Hashtable)defaultProperties).put(QUEUE_DEPTH, "64");
        ((Hashtable)defaultProperties).put(QUEUE_HIWATER, "32");
        ((Hashtable)defaultProperties).put(LOG_LEVEL, "3");
        ((Hashtable)defaultProperties).put(ALIVE, "0");
    }
}

