/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.interfaces.DSAParams;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.spec.DSAPublicKeySpec;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2FatalException;
import com.mindbright.ssh2.SSH2SimpleSignature;
import java.math.BigInteger;

public final class SSH2DSS
extends SSH2SimpleSignature {
    public static final String SSH2_KEY_FORMAT = "ssh-dss";

    public SSH2DSS() {
        super("SHA1withRawDSA", SSH2_KEY_FORMAT);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws SSH2Exception {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(8192);
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new SSH2FatalException("SSH2DSS, invalid public key type: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        sSH2DataBuffer.writeString(SSH2_KEY_FORMAT);
        sSH2DataBuffer.writeBigInt(dSAParams.getP());
        sSH2DataBuffer.writeBigInt(dSAParams.getQ());
        sSH2DataBuffer.writeBigInt(dSAParams.getG());
        sSH2DataBuffer.writeBigInt(dSAPublicKey.getY());
        return sSH2DataBuffer.readRestRaw();
    }

    public PublicKey decodePublicKey(byte[] byArray) throws SSH2Exception {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(byArray.length);
        sSH2DataBuffer.writeRaw(byArray);
        String string = sSH2DataBuffer.readJavaString();
        if (!string.equals(SSH2_KEY_FORMAT)) {
            throw new SSH2FatalException("SSH2DSS, keyblob type mismatch, got '" + string + ", (execpted + '" + SSH2_KEY_FORMAT + "')");
        }
        BigInteger bigInteger = sSH2DataBuffer.readBigInt();
        BigInteger bigInteger2 = sSH2DataBuffer.readBigInt();
        BigInteger bigInteger3 = sSH2DataBuffer.readBigInt();
        BigInteger bigInteger4 = sSH2DataBuffer.readBigInt();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            return keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new SSH2FatalException("SSH2DSS, error decoding public key blob: " + exception);
        }
    }
}

