/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.jcraft.jzlib.ZStream;
import com.mindbright.ssh2.SSH2CompressionException;
import com.mindbright.ssh2.SSH2Compressor;
import com.mindbright.ssh2.SSH2DataBuffer;

public class SSH2CompressorZLib
extends SSH2Compressor {
    private static final int DEFLATE_BUF_SIZE = 49152;
    private static final int INFLATE_BUF_SIZE = 65536;
    private ZStream dStream;
    private ZStream iStream;
    private byte[] dBuf;
    private byte[] iBuf;

    public void init(int n, int n2) {
        switch (n) {
            case 1: {
                this.dStream = new ZStream();
                this.dStream.deflateInit(n2);
                this.dBuf = new byte[49152];
                this.dStream.next_out = this.dBuf;
                break;
            }
            case 2: {
                this.iStream = new ZStream();
                this.iStream.inflateInit();
                this.iBuf = new byte[65536];
                this.iStream.next_out = this.iBuf;
                break;
            }
            default: {
                throw new Error("Unknown mode sent to SSH2CompressorZLib");
            }
        }
    }

    public void compress(SSH2DataBuffer sSH2DataBuffer) throws SSH2CompressionException {
        this.dStream.next_in = sSH2DataBuffer.getData();
        this.dStream.next_in_index = 9;
        this.dStream.avail_in = sSH2DataBuffer.getWPos() - 9;
        this.dStream.next_out_index = 0;
        this.dStream.avail_out = 49152;
        int n = this.dStream.deflate(1);
        if (n != 0) {
            throw new SSH2CompressionException("Error in zlib deflate: " + n);
        }
        int n2 = 49152 - this.dStream.avail_out;
        if (this.dStream.next_in.length - 256 < n2) {
            sSH2DataBuffer.setData(new byte[n2 + (this.dStream.next_in.length >>> 1)]);
        }
        System.arraycopy(this.dBuf, 0, sSH2DataBuffer.getData(), 9, n2);
        sSH2DataBuffer.setWPos(9 + n2);
    }

    public int uncompress(SSH2DataBuffer sSH2DataBuffer, int n) throws SSH2CompressionException {
        this.iStream.next_in = sSH2DataBuffer.getData();
        this.iStream.next_in_index = 9;
        this.iStream.avail_in = n;
        this.iStream.next_out_index = 0;
        this.iStream.avail_out = 65536;
        int n2 = this.iStream.inflate(1);
        if (n2 != 0) {
            throw new SSH2CompressionException("Error in zlib inflate: " + n2);
        }
        int n3 = 65536 - this.iStream.avail_out;
        if (this.iStream.next_in.length - 256 < n3) {
            sSH2DataBuffer.setData(new byte[n3 + (this.iStream.next_in.length >>> 1)]);
        }
        System.arraycopy(this.iBuf, 0, sSH2DataBuffer.getData(), 9, n3);
        return n3;
    }

    public long numOfCompressedBytes() {
        if (this.iStream != null) {
            return this.iStream.total_in;
        }
        return this.dStream.total_out;
    }

    public long numOfUncompressedBytes() {
        if (this.iStream != null) {
            return this.iStream.total_out;
        }
        return this.dStream.total_in;
    }
}

