/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.digest;

import com.mindbright.jca.security.DigestException;
import com.mindbright.jca.security.MessageDigest;

public final class MD2
extends MessageDigest
implements Cloneable {
    public static final int DIGEST_LENGTH = 16;
    private byte[] checksum = new byte[16];
    private byte[] state = new byte[16];
    private byte[] buffer = new byte[16];
    private int rest;
    static final byte[] PI_SUBST = new byte[]{41, 46, 67, -55, -94, -40, 124, 1, 61, 54, 84, -95, -20, -16, 6, 19, 98, -89, 5, -13, -64, -57, 115, -116, -104, -109, 43, -39, -68, 76, -126, -54, 30, -101, 87, 60, -3, -44, -32, 22, 103, 66, 111, 24, -118, 23, -27, 18, -66, 78, -60, -42, -38, -98, -34, 73, -96, -5, -11, -114, -69, 47, -18, 122, -87, 104, 121, -111, 21, -78, 7, 63, -108, -62, 16, -119, 11, 34, 95, 33, -128, 127, 93, -102, 90, -112, 50, 39, 53, 62, -52, -25, -65, -9, -105, 3, -1, 25, 48, -77, 72, -91, -75, -47, -41, 94, -110, 42, -84, 86, -86, -58, 79, -72, 56, -46, -106, -92, 125, -74, 118, -4, 107, -30, -100, 116, 4, -15, 69, -99, 112, 89, 100, 113, -121, 32, -122, 91, -49, 101, -26, 45, -88, 2, 27, 96, 37, -83, -82, -80, -71, -10, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, -93, 35, -35, 81, -81, 58, -61, 92, -7, -50, -70, -59, -22, 38, 44, 83, 13, 110, -123, 40, -124, 9, -45, -33, -51, -12, 65, -127, 77, 82, 106, -36, 55, -56, 108, -63, -85, -6, 36, -31, 123, 8, 12, -67, -79, 74, 120, -120, -107, -117, -29, 99, -24, 109, -23, -53, -43, -2, 59, 0, 29, 57, -14, -17, -73, 14, 102, 88, -48, -28, -90, 119, 114, -8, -21, 117, 75, 10, 49, 68, 80, -76, -113, -19, 31, 26, -37, -103, -115, 51, -97, 17, -125, 20};
    static final byte[][] padding = new byte[][]{{0}, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}, {9, 9, 9, 9, 9, 9, 9, 9, 9}, {10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}};

    private void transform(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = new byte[48];
        for (n2 = 0; n2 < 16; ++n2) {
            byte by = this.state[n2];
            byte by2 = byArray[n + n2];
            byArray2[n2] = by;
            byArray2[16 + n2] = by2;
            byArray2[32 + n2] = (byte)(by ^ by2);
        }
        int n3 = 0;
        for (n2 = 0; n2 < 18; ++n2) {
            for (int i = 0; i < 48; ++i) {
                int n4 = i;
                byArray2[n4] = (byte)(byArray2[n4] ^ PI_SUBST[n3]);
                n3 = byArray2[i] & 0xFF;
            }
            n3 = n3 + n2 & 0xFF;
        }
        n3 = this.checksum[15] & 0xFF;
        for (n2 = 0; n2 < 16; ++n2) {
            this.state[n2] = byArray2[n2];
            int n5 = n2;
            this.checksum[n5] = (byte)(this.checksum[n5] ^ PI_SUBST[byArray[n + n2] & 0xFF ^ n3]);
            n3 = this.checksum[n2] & 0xFF;
        }
    }

    public MD2() {
        super("MD2");
    }

    private MD2(MD2 mD2) {
        super("MD2");
        for (int i = 0; i < 16; ++i) {
            this.checksum[i] = mD2.checksum[i];
            this.state[i] = mD2.state[i];
            this.buffer[i] = mD2.buffer[i];
        }
        this.rest = mD2.rest;
    }

    public Object clone() {
        return new MD2(this);
    }

    protected void engineReset() {
        for (int i = 0; i < 16; ++i) {
            this.checksum[i] = 0;
            this.state[i] = 0;
            this.buffer[i] = 0;
        }
        this.rest = 0;
    }

    protected void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = 16 - this.rest;
        if (this.rest > 0 && n2 >= n3) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n3);
            this.transform(this.buffer, 0);
            n += n3;
            n2 -= n3;
            this.rest = 0;
        }
        while (n2 > 15) {
            this.transform(byArray, n);
            n += 16;
            n2 -= 16;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.rest, n2);
            this.rest += n2;
        }
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[16];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = 16 - this.rest;
        if (n2 < 16) {
            throw new DigestException("MD2, output buffer too short");
        }
        this.engineUpdate(padding[n3], 0, n3);
        this.engineUpdate(this.checksum, 0, 16);
        System.arraycopy(this.state, 0, byArray, n, 16);
        this.engineReset();
        return 16;
    }

    protected int engineGetDigestLength() {
        return 16;
    }
}

