/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net.telnet;

import com.mindbright.net.telnet.TelnetEventHandler;
import com.mindbright.net.telnet.TelnetNVT;
import com.mindbright.terminal.TerminalInputChaff;
import com.mindbright.terminal.TerminalWindow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class TelnetTerminalAdapter
extends TerminalInputChaff
implements TelnetEventHandler {
    private TelnetNVT telnet;
    private TerminalWindow terminal;
    private StringBuffer lineBuffer;
    private boolean bufferedInput;
    private boolean doNAWS;

    public TelnetTerminalAdapter(InputStream inputStream, OutputStream outputStream, TerminalWindow terminalWindow) {
        this.telnet = new TelnetNVT(this, inputStream, outputStream);
        this.terminal = terminalWindow;
        this.lineBuffer = new StringBuffer();
        this.bufferedInput = true;
        terminalWindow.addInputListener(this);
        try {
            terminalWindow.setProperty("auto-linefeed", "true");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.telnet.start();
    }

    public TelnetNVT getTelnetNVT() {
        return this.telnet;
    }

    public boolean isBuffered() {
        return this.bufferedInput;
    }

    public void interpretAsCommand(int n) {
    }

    public void optionSubNegotiation(int n, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        if (byArray[0] == 1) {
            switch (n) {
                case 24: {
                    byArray2 = this.terminal.terminalType().getBytes();
                    break;
                }
                case 32: {
                    byArray2 = "38400,38400".getBytes();
                }
            }
        }
        if (byArray2 != null) {
            byte[] byArray3 = byArray2;
            int n2 = byArray3.length;
            byArray2 = new byte[n2 + 1];
            byArray2[0] = 0;
            System.arraycopy(byArray3, 0, byArray2, 1, n2);
            this.telnet.sendOptionSubNegotiation(n, byArray2);
        }
    }

    public boolean optionNegotiation(int n, int n2) throws IOException {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 3: 
            case 5: {
                if (n2 != 251) break;
                bl = true;
                this.telnet.doOption(n);
                if (n != 1) break;
                this.bufferedInput = false;
                try {
                    this.terminal.setProperty("auto-linefeed", "false");
                }
                catch (NoSuchElementException noSuchElementException) {}
                break;
            }
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                if (n2 != 253) break;
                bl = true;
                this.telnet.willOption(n);
                if (n != 31) break;
                this.doNAWS = true;
                this.signalWindowChanged(this.terminal.rows(), this.terminal.cols(), this.terminal.vpixels(), this.terminal.hpixels());
            }
        }
        return bl;
    }

    public void receiveData(byte by) {
        this.terminal.write(by);
    }

    protected void sendTypedChar(int n) {
        try {
            if (this.bufferedInput) {
                if (n == 127 || n == 8) {
                    if (this.lineBuffer.length() > 0) {
                        boolean bl = false;
                        if (this.lineBuffer.charAt(this.lineBuffer.length() - 1) < ' ') {
                            bl = true;
                        }
                        this.lineBuffer.setLength(this.lineBuffer.length() - 1);
                        this.terminal.write('\b');
                        if (bl) {
                            this.terminal.write('\b');
                        }
                        this.terminal.write(' ');
                        if (bl) {
                            this.terminal.write(' ');
                        }
                        this.terminal.write('\b');
                        if (bl) {
                            this.terminal.write('\b');
                        }
                    } else {
                        this.terminal.ringBell();
                    }
                } else if (n == 10) {
                    this.terminal.write((char)n);
                    this.lineBuffer.append((char)n);
                    byte[] byArray = this.lineBuffer.toString().getBytes();
                    this.telnet.sendData(byArray, 0, byArray.length);
                    this.lineBuffer.setLength(0);
                } else {
                    this.lineBuffer.append(n);
                    this.terminal.write((char)n);
                }
            } else if (n == 13) {
                this.telnet.sendCR();
            } else {
                this.telnet.sendData(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendFakeChar() {
    }

    public void sendBytes(byte[] byArray) {
        if (this.isChaffActive() || this.bufferedInput) {
            for (int i = 0; i < byArray.length; ++i) {
                this.typedChar((char)byArray[i]);
            }
        } else {
            try {
                this.telnet.sendData(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void signalWindowChanged(int n, int n2, int n3, int n4) {
        if (this.doNAWS) {
            byte[] byArray = new byte[]{(byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            try {
                this.telnet.sendOptionSubNegotiation(31, byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void sendBreak() {
        try {
            this.telnet.sendBreak();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

