/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net;

import com.mindbright.net.RFC822Head;
import com.mindbright.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpHeader {
    private static final String WHITE_SPACE = " \t\r";
    String startLine;
    RFC822Head headerFields;
    boolean isResponse;

    public HttpHeader() {
        this.headerFields = new RFC822Head();
    }

    public HttpHeader(String string) throws IOException {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public HttpHeader(InputStream inputStream) throws IOException {
        this.startLine = this.readLine(inputStream);
        while (this.startLine.trim().length() == 0) {
            this.startLine = this.readLine(inputStream);
        }
        this.headerFields = new RFC822Head(inputStream);
    }

    private String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                throw new IOException("HttpHeader, corrupt header, input stream closed");
            }
            if (n == 10) continue;
            if (n == 13) break;
            stringBuffer.append((char)n);
        }
        return new String(stringBuffer);
    }

    public String getStartLine() {
        return this.startLine;
    }

    public void setStartLine(String string) {
        this.startLine = string;
    }

    public RFC822Head getHeader() {
        return this.headerFields;
    }

    public String getHeaderField(String string) {
        return this.headerFields.getHeaderField(string);
    }

    public void setHeaderField(String string, String string2) {
        this.headerFields.setHeaderField(string, string2);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        String string = this.toString();
        outputStream.write(string.getBytes());
        outputStream.flush();
    }

    public int getStatus() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.startLine, WHITE_SPACE, false);
        String string = null;
        int n = -1;
        String string2 = null;
        try {
            string = stringTokenizer.nextToken();
            n = Integer.parseInt(stringTokenizer.nextToken());
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            n = -1;
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public void setBasicProxyAuth(String string, String string2) {
        String string3 = string + ":" + string2;
        byte[] byArray = Base64.encode(string3.getBytes());
        this.setHeaderField("Proxy-Authorization", "Basic " + new String(byArray));
    }

    public String getProxyAuthMethod() {
        String string = this.headerFields.getHeaderField("Proxy-Authenticate");
        String string2 = null;
        if (string != null) {
            int n = string.indexOf(32);
            string2 = n >= 0 ? string.substring(0, n) : string;
        }
        return string2;
    }

    public String getProxyAuthRealm() {
        String string = this.headerFields.getHeaderField("Proxy-Authenticate");
        String string2 = null;
        if (string != null) {
            int n = string.indexOf(61);
            while (n >= 0) {
                int n2 = string.lastIndexOf(32, n);
                string2 = string.substring(n2 + 1, n);
                if (string2.equalsIgnoreCase("realm")) {
                    n2 = n + 2;
                    n = string.indexOf(34, n2);
                    string2 = string.substring(n2, n);
                    break;
                }
                n = string.indexOf(61, n + 1);
            }
        }
        return string2;
    }

    public String toString() {
        String string = this.startLine + "\r\n";
        Enumeration enumeration = this.headerFields.getHeaderFieldNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + ": " + this.headerFields.getHeaderField(string2) + "\r\n";
        }
        string = string + "\r\n";
        return string;
    }
}

