/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.StaticTree;
import com.jcraft.jzlib.Tree;
import com.jcraft.jzlib.ZStream;

public final class Deflate {
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_DEFAULT_COMPRESSION = -1;
    private static final int MAX_WBITS = 15;
    private static final int DEF_MEM_LEVEL = 8;
    private static final int STORED = 0;
    private static final int FAST = 1;
    private static final int SLOW = 2;
    private static final Config[] config_table = new Config[]{new Config(0, 0, 0, 0, 0), new Config(4, 4, 8, 4, 1), new Config(4, 5, 16, 8, 1), new Config(4, 6, 32, 32, 1), new Config(4, 4, 16, 16, 2), new Config(8, 16, 32, 32, 2), new Config(8, 16, 128, 128, 2), new Config(8, 32, 128, 256, 2), new Config(32, 128, 258, 1024, 2), new Config(32, 258, 258, 4096, 2)};
    private static final String[] z_errmsg = new String[]{"need dictionary", "stream end", "", "file error", "stream error", "data error", "insufficient memory", "buffer error", "incompatible version", ""};
    private static final int NeedMore = 0;
    private static final int BlockDone = 1;
    private static final int FinishStarted = 2;
    private static final int FinishDone = 3;
    private static final int PRESET_DICT = 32;
    private static final int Z_FILTERED = 1;
    private static final int Z_HUFFMAN_ONLY = 2;
    private static final int Z_DEFAULT_STRATEGY = 0;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private static final int INIT_STATE = 42;
    private static final int BUSY_STATE = 113;
    private static final int FINISH_STATE = 666;
    private static final int Z_DEFLATED = 8;
    private static final int STORED_BLOCK = 0;
    private static final int STATIC_TREES = 1;
    private static final int DYN_TREES = 2;
    private static final int Z_BINARY = 0;
    private static final int Z_ASCII = 1;
    private static final int Z_UNKNOWN = 2;
    private static final int Buf_size = 16;
    private static final int REP_3_6 = 16;
    private static final int REPZ_3_10 = 17;
    private static final int REPZ_11_138 = 18;
    private static final int MIN_MATCH = 3;
    private static final int MAX_MATCH = 258;
    private static final int MIN_LOOKAHEAD = 262;
    private static final int MAX_BITS = 15;
    private static final int D_CODES = 30;
    private static final int BL_CODES = 19;
    private static final int LENGTH_CODES = 29;
    private static final int LITERALS = 256;
    private static final int L_CODES = 286;
    private static final int HEAP_SIZE = 573;
    private static final int END_BLOCK = 256;
    ZStream strm;
    int status;
    byte[] pending_buf;
    int pending_buf_size;
    int pending_out;
    int pending;
    int noheader;
    byte data_type;
    byte method;
    int last_flush;
    int w_size;
    int w_bits;
    int w_mask;
    byte[] window;
    int window_size;
    short[] prev;
    short[] head;
    int ins_h;
    int hash_size;
    int hash_bits;
    int hash_mask;
    int hash_shift;
    int block_start;
    int match_length;
    int prev_match;
    int match_available;
    int strstart;
    int match_start;
    int lookahead;
    int prev_length;
    int max_chain_length;
    int max_lazy_match;
    int level;
    int strategy;
    int good_match;
    int nice_match;
    short[] dyn_ltree;
    short[] dyn_dtree;
    short[] bl_tree;
    Tree l_desc = new Tree();
    Tree d_desc = new Tree();
    Tree bl_desc = new Tree();
    short[] bl_count = new short[16];
    int[] heap = new int[573];
    int heap_len;
    int heap_max;
    byte[] depth = new byte[573];
    int l_buf;
    int lit_bufsize;
    int last_lit;
    int d_buf;
    int opt_len;
    int static_len;
    int matches;
    int last_eob_len;
    short bi_buf;
    int bi_valid;

    Deflate() {
        this.dyn_ltree = new short[1146];
        this.dyn_dtree = new short[122];
        this.bl_tree = new short[78];
    }

    void lm_init() {
        this.window_size = 2 * this.w_size;
        this.head[this.hash_size - 1] = 0;
        for (int i = 0; i < this.hash_size - 1; ++i) {
            this.head[i] = 0;
        }
        this.max_lazy_match = Deflate.config_table[this.level].max_lazy;
        this.good_match = Deflate.config_table[this.level].good_length;
        this.nice_match = Deflate.config_table[this.level].nice_length;
        this.max_chain_length = Deflate.config_table[this.level].max_chain;
        this.strstart = 0;
        this.block_start = 0;
        this.lookahead = 0;
        this.prev_length = 2;
        this.match_length = 2;
        this.match_available = 0;
        this.ins_h = 0;
    }

    void tr_init() {
        this.l_desc.dyn_tree = this.dyn_ltree;
        this.l_desc.stat_desc = StaticTree.static_l_desc;
        this.d_desc.dyn_tree = this.dyn_dtree;
        this.d_desc.stat_desc = StaticTree.static_d_desc;
        this.bl_desc.dyn_tree = this.bl_tree;
        this.bl_desc.stat_desc = StaticTree.static_bl_desc;
        this.bi_buf = 0;
        this.bi_valid = 0;
        this.last_eob_len = 8;
        this.init_block();
    }

    void init_block() {
        int n;
        for (n = 0; n < 286; ++n) {
            this.dyn_ltree[n * 2] = 0;
        }
        for (n = 0; n < 30; ++n) {
            this.dyn_dtree[n * 2] = 0;
        }
        for (n = 0; n < 19; ++n) {
            this.bl_tree[n * 2] = 0;
        }
        this.dyn_ltree[512] = 1;
        this.static_len = 0;
        this.opt_len = 0;
        this.matches = 0;
        this.last_lit = 0;
    }

    void pqdownheap(short[] sArray, int n) {
        int n2 = this.heap[n];
        for (int i = n << 1; i <= this.heap_len; i <<= 1) {
            if (i < this.heap_len && Deflate.smaller(sArray, this.heap[i + 1], this.heap[i], this.depth)) {
                ++i;
            }
            if (Deflate.smaller(sArray, n2, this.heap[i], this.depth)) break;
            this.heap[n] = this.heap[i];
            n = i;
        }
        this.heap[n] = n2;
    }

    static boolean smaller(short[] sArray, int n, int n2, byte[] byArray) {
        return sArray[n * 2] < sArray[n2 * 2] || sArray[n * 2] == sArray[n2 * 2] && byArray[n] <= byArray[n2];
    }

    void scan_tree(short[] sArray, int n) {
        short s = -1;
        short s2 = sArray[1];
        int n2 = 0;
        int n3 = 7;
        int n4 = 4;
        if (s2 == 0) {
            n3 = 138;
            n4 = 3;
        }
        sArray[(n + 1) * 2 + 1] = -1;
        for (int i = 0; i <= n; ++i) {
            short s3 = s2;
            s2 = sArray[(i + 1) * 2 + 1];
            if (++n2 < n3 && s3 == s2) continue;
            if (n2 < n4) {
                int n5 = s3 * 2;
                this.bl_tree[n5] = (short)(this.bl_tree[n5] + n2);
            } else if (s3 != 0) {
                if (s3 != s) {
                    int n6 = s3 * 2;
                    this.bl_tree[n6] = (short)(this.bl_tree[n6] + 1);
                }
                this.bl_tree[32] = (short)(this.bl_tree[32] + 1);
            } else if (n2 <= 10) {
                this.bl_tree[34] = (short)(this.bl_tree[34] + 1);
            } else {
                this.bl_tree[36] = (short)(this.bl_tree[36] + 1);
            }
            n2 = 0;
            s = s3;
            if (s2 == 0) {
                n3 = 138;
                n4 = 3;
                continue;
            }
            if (s3 == s2) {
                n3 = 6;
                n4 = 3;
                continue;
            }
            n3 = 7;
            n4 = 4;
        }
    }

    int build_bl_tree() {
        int n;
        this.scan_tree(this.dyn_ltree, this.l_desc.max_code);
        this.scan_tree(this.dyn_dtree, this.d_desc.max_code);
        this.bl_desc.build_tree(this);
        for (n = 18; n >= 3 && this.bl_tree[Tree.bl_order[n] * 2 + 1] == 0; --n) {
        }
        this.opt_len += 3 * (n + 1) + 5 + 5 + 4;
        return n;
    }

    void send_all_trees(int n, int n2, int n3) {
        this.send_bits(n - 257, 5);
        this.send_bits(n2 - 1, 5);
        this.send_bits(n3 - 4, 4);
        for (int i = 0; i < n3; ++i) {
            this.send_bits(this.bl_tree[Tree.bl_order[i] * 2 + 1], 3);
        }
        this.send_tree(this.dyn_ltree, n - 1);
        this.send_tree(this.dyn_dtree, n2 - 1);
    }

    void send_tree(short[] sArray, int n) {
        short s = -1;
        short s2 = sArray[1];
        int n2 = 0;
        int n3 = 7;
        int n4 = 4;
        if (s2 == 0) {
            n3 = 138;
            n4 = 3;
        }
        for (int i = 0; i <= n; ++i) {
            short s3 = s2;
            s2 = sArray[(i + 1) * 2 + 1];
            if (++n2 < n3 && s3 == s2) continue;
            if (n2 < n4) {
                do {
                    this.send_code(s3, this.bl_tree);
                } while (--n2 != 0);
            } else if (s3 != 0) {
                if (s3 != s) {
                    this.send_code(s3, this.bl_tree);
                    --n2;
                }
                this.send_code(16, this.bl_tree);
                this.send_bits(n2 - 3, 2);
            } else if (n2 <= 10) {
                this.send_code(17, this.bl_tree);
                this.send_bits(n2 - 3, 3);
            } else {
                this.send_code(18, this.bl_tree);
                this.send_bits(n2 - 11, 7);
            }
            n2 = 0;
            s = s3;
            if (s2 == 0) {
                n3 = 138;
                n4 = 3;
                continue;
            }
            if (s3 == s2) {
                n3 = 6;
                n4 = 3;
                continue;
            }
            n3 = 7;
            n4 = 4;
        }
    }

    final void put_byte(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.pending_buf, this.pending, n2);
        this.pending += n2;
    }

    final void put_byte(byte by) {
        this.pending_buf[this.pending++] = by;
    }

    final void put_short(int n) {
        this.put_byte((byte)n);
        this.put_byte((byte)(n >>> 8));
    }

    final void putShortMSB(int n) {
        this.put_byte((byte)(n >> 8));
        this.put_byte((byte)n);
    }

    final void send_code(int n, short[] sArray) {
        this.send_bits(sArray[n * 2] & 0xFFFF, sArray[n * 2 + 1] & 0xFFFF);
    }

    void send_bits(int n, int n2) {
        int n3 = n2;
        if (this.bi_valid > 16 - n3) {
            int n4 = n;
            this.bi_buf = (short)(this.bi_buf | n4 << this.bi_valid & 0xFFFF);
            this.put_short(this.bi_buf);
            this.bi_buf = (short)(n4 >>> 16 - this.bi_valid);
            this.bi_valid += n3 - 16;
        } else {
            this.bi_buf = (short)(this.bi_buf | n << this.bi_valid & 0xFFFF);
            this.bi_valid += n3;
        }
    }

    void _tr_align() {
        this.send_bits(2, 3);
        this.send_code(256, StaticTree.static_ltree);
        this.bi_flush();
        if (1 + this.last_eob_len + 10 - this.bi_valid < 9) {
            this.send_bits(2, 3);
            this.send_code(256, StaticTree.static_ltree);
            this.bi_flush();
        }
        this.last_eob_len = 7;
    }

    boolean _tr_tally(int n, int n2) {
        this.pending_buf[this.d_buf + this.last_lit * 2] = (byte)(n >>> 8);
        this.pending_buf[this.d_buf + this.last_lit * 2 + 1] = (byte)n;
        this.pending_buf[this.l_buf + this.last_lit] = (byte)n2;
        ++this.last_lit;
        if (n == 0) {
            int n3 = n2 * 2;
            this.dyn_ltree[n3] = (short)(this.dyn_ltree[n3] + 1);
        } else {
            ++this.matches;
            int n4 = (Tree._length_code[n2] + 256 + 1) * 2;
            this.dyn_ltree[n4] = (short)(this.dyn_ltree[n4] + 1);
            int n5 = Tree.d_code(--n) * 2;
            this.dyn_dtree[n5] = (short)(this.dyn_dtree[n5] + 1);
        }
        if ((this.last_lit & 0x1FFF) == 0 && this.level > 2) {
            int n6 = this.last_lit * 8;
            int n7 = this.strstart - this.block_start;
            for (int i = 0; i < 30; ++i) {
                n6 = (int)((long)n6 + (long)this.dyn_dtree[i * 2] * (5L + (long)Tree.extra_dbits[i]));
            }
            if (this.matches < this.last_lit / 2 && (n6 >>>= 3) < n7 / 2) {
                return true;
            }
        }
        return this.last_lit == this.lit_bufsize - 1;
    }

    void compress_block(short[] sArray, short[] sArray2) {
        int n = 0;
        if (this.last_lit != 0) {
            do {
                int n2 = this.pending_buf[this.d_buf + n * 2] << 8 & 0xFF00 | this.pending_buf[this.d_buf + n * 2 + 1] & 0xFF;
                int n3 = this.pending_buf[this.l_buf + n] & 0xFF;
                ++n;
                if (n2 == 0) {
                    this.send_code(n3, sArray);
                    continue;
                }
                int n4 = Tree._length_code[n3];
                this.send_code(n4 + 256 + 1, sArray);
                int n5 = Tree.extra_lbits[n4];
                if (n5 != 0) {
                    this.send_bits(n3 -= Tree.base_length[n4], n5);
                }
                n4 = Tree.d_code(--n2);
                this.send_code(n4, sArray2);
                n5 = Tree.extra_dbits[n4];
                if (n5 == 0) continue;
                this.send_bits(n2 -= Tree.base_dist[n4], n5);
            } while (n < this.last_lit);
        }
        this.send_code(256, sArray);
        this.last_eob_len = sArray[513];
    }

    void set_data_type() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 7; ++n) {
            n3 += this.dyn_ltree[n * 2];
        }
        while (n < 128) {
            n2 += this.dyn_ltree[n * 2];
            ++n;
        }
        while (n < 256) {
            n3 += this.dyn_ltree[n * 2];
            ++n;
        }
        this.data_type = (byte)(n3 <= n2 >>> 2 ? 1 : 0);
    }

    void bi_flush() {
        if (this.bi_valid == 16) {
            this.put_short(this.bi_buf);
            this.bi_buf = 0;
            this.bi_valid = 0;
        } else if (this.bi_valid >= 8) {
            this.put_byte((byte)this.bi_buf);
            this.bi_buf = (short)(this.bi_buf >>> 8);
            this.bi_valid -= 8;
        }
    }

    void bi_windup() {
        if (this.bi_valid > 8) {
            this.put_short(this.bi_buf);
        } else if (this.bi_valid > 0) {
            this.put_byte((byte)this.bi_buf);
        }
        this.bi_buf = 0;
        this.bi_valid = 0;
    }

    void copy_block(int n, int n2, boolean bl) {
        boolean bl2 = false;
        this.bi_windup();
        this.last_eob_len = 8;
        if (bl) {
            this.put_short((short)n2);
            this.put_short((short)(~n2));
        }
        this.put_byte(this.window, n, n2);
    }

    void flush_block_only(boolean bl) {
        this._tr_flush_block(this.block_start >= 0 ? this.block_start : -1, this.strstart - this.block_start, bl);
        this.block_start = this.strstart;
        this.strm.flush_pending();
    }

    int deflate_stored(int n) {
        block7: {
            int n2 = 65535;
            if (n2 > this.pending_buf_size - 5) {
                n2 = this.pending_buf_size - 5;
            }
            while (true) {
                if (this.lookahead <= 1) {
                    this.fill_window();
                    if (this.lookahead == 0 && n == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block7;
                }
                this.strstart += this.lookahead;
                this.lookahead = 0;
                int n3 = this.block_start + n2;
                if (this.strstart == 0 || this.strstart >= n3) {
                    this.lookahead = this.strstart - n3;
                    this.strstart = n3;
                    this.flush_block_only(false);
                    if (this.strm.avail_out == 0) {
                        return 0;
                    }
                }
                if (this.strstart - this.block_start < this.w_size - 262) continue;
                this.flush_block_only(false);
                if (this.strm.avail_out == 0) break;
            }
            return 0;
        }
        this.flush_block_only(n == 4);
        if (this.strm.avail_out == 0) {
            return n == 4 ? 2 : 0;
        }
        return n == 4 ? 3 : 1;
    }

    void _tr_stored_block(int n, int n2, boolean bl) {
        this.send_bits(0 + (bl ? 1 : 0), 3);
        this.copy_block(n, n2, true);
    }

    void _tr_flush_block(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = 0;
        if (this.level > 0) {
            if (this.data_type == 2) {
                this.set_data_type();
            }
            this.l_desc.build_tree(this);
            this.d_desc.build_tree(this);
            n5 = this.build_bl_tree();
            n4 = this.opt_len + 3 + 7 >>> 3;
            n3 = this.static_len + 3 + 7 >>> 3;
            if (n3 <= n4) {
                n4 = n3;
            }
        } else {
            n4 = n3 = n2 + 5;
        }
        if (n2 + 4 <= n4 && n != -1) {
            this._tr_stored_block(n, n2, bl);
        } else if (n3 == n4) {
            this.send_bits(2 + (bl ? 1 : 0), 3);
            this.compress_block(StaticTree.static_ltree, StaticTree.static_dtree);
        } else {
            this.send_bits(4 + (bl ? 1 : 0), 3);
            this.send_all_trees(this.l_desc.max_code + 1, this.d_desc.max_code + 1, n5 + 1);
            this.compress_block(this.dyn_ltree, this.dyn_dtree);
        }
        this.init_block();
        if (bl) {
            this.bi_windup();
        }
    }

    void fill_window() {
        do {
            int n;
            int n2;
            if ((n2 = this.window_size - this.lookahead - this.strstart) == 0 && this.strstart == 0 && this.lookahead == 0) {
                n2 = this.w_size;
            } else if (n2 == -1) {
                --n2;
            } else if (this.strstart >= this.w_size + this.w_size - 262) {
                int n3;
                System.arraycopy(this.window, this.w_size, this.window, 0, this.w_size);
                this.match_start -= this.w_size;
                this.strstart -= this.w_size;
                this.block_start -= this.w_size;
                int n4 = n = this.hash_size;
                do {
                    short s = this.head[n4] = (n3 = this.head[--n4] & 0xFFFF) >= this.w_size ? (short)(n3 - this.w_size) : (short)0;
                } while (--n != 0);
                n4 = n = this.w_size;
                do {
                    short s = this.prev[n4] = (n3 = this.prev[--n4] & 0xFFFF) >= this.w_size ? (short)(n3 - this.w_size) : (short)0;
                } while (--n != 0);
                n2 += this.w_size;
            }
            if (this.strm.avail_in == 0) {
                return;
            }
            n = this.strm.read_buf(this.window, this.strstart + this.lookahead, n2);
            this.lookahead += n;
            if (this.lookahead < 3) continue;
            this.ins_h = this.window[this.strstart] & 0xFF;
            this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 1] & 0xFF) & this.hash_mask;
        } while (this.lookahead < 262 && this.strm.avail_in != 0);
    }

    int deflate_fast(int n) {
        block12: {
            int n2 = 0;
            while (true) {
                boolean bl;
                if (this.lookahead < 262) {
                    this.fill_window();
                    if (this.lookahead < 262 && n == 0) {
                        return 0;
                    }
                    if (this.lookahead == 0) break block12;
                }
                if (this.lookahead >= 3) {
                    this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                    n2 = this.head[this.ins_h] & 0xFFFF;
                    this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                    this.head[this.ins_h] = (short)this.strstart;
                }
                if ((long)n2 != 0L && (this.strstart - n2 & 0xFFFF) <= this.w_size - 262 && this.strategy != 2) {
                    this.match_length = this.longest_match(n2);
                }
                if (this.match_length >= 3) {
                    bl = this._tr_tally(this.strstart - this.match_start, this.match_length - 3);
                    this.lookahead -= this.match_length;
                    if (this.match_length <= this.max_lazy_match && this.lookahead >= 3) {
                        --this.match_length;
                        do {
                            ++this.strstart;
                            this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                            n2 = this.head[this.ins_h] & 0xFFFF;
                            this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                            this.head[this.ins_h] = (short)this.strstart;
                        } while (--this.match_length != 0);
                        ++this.strstart;
                    } else {
                        this.strstart += this.match_length;
                        this.match_length = 0;
                        this.ins_h = this.window[this.strstart] & 0xFF;
                        this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 1] & 0xFF) & this.hash_mask;
                    }
                } else {
                    bl = this._tr_tally(0, this.window[this.strstart] & 0xFF);
                    --this.lookahead;
                    ++this.strstart;
                }
                if (!bl) continue;
                this.flush_block_only(false);
                if (this.strm.avail_out == 0) break;
            }
            return 0;
        }
        this.flush_block_only(n == 4);
        if (this.strm.avail_out == 0) {
            if (n == 4) {
                return 2;
            }
            return 0;
        }
        return n == 4 ? 3 : 1;
    }

    int deflate_slow(int n) {
        boolean bl;
        int n2 = 0;
        while (true) {
            if (this.lookahead < 262) {
                this.fill_window();
                if (this.lookahead < 262 && n == 0) {
                    return 0;
                }
                if (this.lookahead == 0) break;
            }
            if (this.lookahead >= 3) {
                this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                n2 = this.head[this.ins_h] & 0xFFFF;
                this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                this.head[this.ins_h] = (short)this.strstart;
            }
            this.prev_length = this.match_length;
            this.prev_match = this.match_start;
            this.match_length = 2;
            if (n2 != 0 && this.prev_length < this.max_lazy_match && (this.strstart - n2 & 0xFFFF) <= this.w_size - 262) {
                if (this.strategy != 2) {
                    this.match_length = this.longest_match(n2);
                }
                if (this.match_length <= 5 && (this.strategy == 1 || this.match_length == 3 && this.strstart - this.match_start > 4096)) {
                    this.match_length = 2;
                }
            }
            if (this.prev_length >= 3 && this.match_length <= this.prev_length) {
                int n3 = this.strstart + this.lookahead - 3;
                bl = this._tr_tally(this.strstart - 1 - this.prev_match, this.prev_length - 3);
                this.lookahead -= this.prev_length - 1;
                this.prev_length -= 2;
                do {
                    if (++this.strstart > n3) continue;
                    this.ins_h = (this.ins_h << this.hash_shift ^ this.window[this.strstart + 2] & 0xFF) & this.hash_mask;
                    n2 = this.head[this.ins_h] & 0xFFFF;
                    this.prev[this.strstart & this.w_mask] = this.head[this.ins_h];
                    this.head[this.ins_h] = (short)this.strstart;
                } while (--this.prev_length != 0);
                this.match_available = 0;
                this.match_length = 2;
                ++this.strstart;
                if (!bl) continue;
                this.flush_block_only(false);
                if (this.strm.avail_out != 0) continue;
                return 0;
            }
            if (this.match_available != 0) {
                bl = this._tr_tally(0, this.window[this.strstart - 1] & 0xFF);
                if (bl) {
                    this.flush_block_only(false);
                }
                ++this.strstart;
                --this.lookahead;
                if (this.strm.avail_out != 0) continue;
                return 0;
            }
            this.match_available = 1;
            ++this.strstart;
            --this.lookahead;
        }
        if (this.match_available != 0) {
            bl = this._tr_tally(0, this.window[this.strstart - 1] & 0xFF);
            this.match_available = 0;
        }
        this.flush_block_only(n == 4);
        if (this.strm.avail_out == 0) {
            if (n == 4) {
                return 2;
            }
            return 0;
        }
        return n == 4 ? 3 : 1;
    }

    int longest_match(int n) {
        int n2 = this.max_chain_length;
        int n3 = this.strstart;
        int n4 = this.prev_length;
        int n5 = this.strstart > this.w_size - 262 ? this.strstart - (this.w_size - 262) : 0;
        int n6 = this.nice_match;
        int n7 = this.w_mask;
        int n8 = this.strstart + 258;
        byte by = this.window[n3 + n4 - 1];
        byte by2 = this.window[n3 + n4];
        if (this.prev_length >= this.good_match) {
            n2 >>= 2;
        }
        if (n6 > this.lookahead) {
            n6 = this.lookahead;
        }
        do {
            int n9;
            if (this.window[(n9 = n) + n4] != by2 || this.window[n9 + n4 - 1] != by || this.window[n9] != this.window[n3] || this.window[++n9] != this.window[n3 + 1]) continue;
            n3 += 2;
            ++n9;
            while (this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && this.window[++n3] == this.window[++n9] && n3 < n8) {
            }
            int n10 = 258 - (n8 - n3);
            n3 = n8 - 258;
            if (n10 <= n4) continue;
            this.match_start = n;
            n4 = n10;
            if (n10 >= n6) break;
            by = this.window[n3 + n4 - 1];
            by2 = this.window[n3 + n4];
        } while ((n = this.prev[n & n7] & 0xFFFF) > n5 && --n2 != 0);
        if (n4 <= this.lookahead) {
            return n4;
        }
        return this.lookahead;
    }

    int deflateInit(ZStream zStream, int n, int n2) {
        return this.deflateInit2(zStream, n, 8, n2, 8, 0);
    }

    int deflateInit(ZStream zStream, int n) {
        return this.deflateInit(zStream, n, 15);
    }

    int deflateInit2(ZStream zStream, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        zStream.msg = null;
        if (n == -1) {
            n = 6;
        }
        if (n3 < 0) {
            n6 = 1;
            n3 = -n3;
        }
        if (n4 < 1 || n4 > 9 || n2 != 8 || n3 < 9 || n3 > 15 || n < 0 || n > 9 || n5 < 0 || n5 > 2) {
            return -2;
        }
        zStream.dstate = this;
        this.noheader = n6;
        this.w_bits = n3;
        this.w_size = 1 << this.w_bits;
        this.w_mask = this.w_size - 1;
        this.hash_bits = n4 + 7;
        this.hash_size = 1 << this.hash_bits;
        this.hash_mask = this.hash_size - 1;
        this.hash_shift = (this.hash_bits + 3 - 1) / 3;
        this.window = new byte[this.w_size * 2];
        this.prev = new short[this.w_size];
        this.head = new short[this.hash_size];
        this.lit_bufsize = 1 << n4 + 6;
        this.pending_buf = new byte[this.lit_bufsize * 4];
        this.pending_buf_size = this.lit_bufsize * 4;
        this.d_buf = this.lit_bufsize / 2;
        this.l_buf = 3 * this.lit_bufsize;
        this.level = n;
        this.strategy = n5;
        this.method = (byte)n2;
        return this.deflateReset(zStream);
    }

    int deflateReset(ZStream zStream) {
        zStream.total_out = 0L;
        zStream.total_in = 0L;
        zStream.msg = null;
        zStream.data_type = 2;
        this.pending = 0;
        this.pending_out = 0;
        if (this.noheader < 0) {
            this.noheader = 0;
        }
        this.status = this.noheader != 0 ? 113 : 42;
        zStream.adler = zStream._adler.adler32(0L, null, 0, 0);
        this.last_flush = 0;
        this.tr_init();
        this.lm_init();
        return 0;
    }

    int deflateEnd() {
        if (this.status != 42 && this.status != 113 && this.status != 666) {
            return -2;
        }
        this.pending_buf = null;
        this.head = null;
        this.prev = null;
        this.window = null;
        return this.status == 113 ? -3 : 0;
    }

    int deflateParams(ZStream zStream, int n, int n2) {
        int n3 = 0;
        if (n == -1) {
            n = 6;
        }
        if (n < 0 || n > 9 || n2 < 0 || n2 > 2) {
            return -2;
        }
        if (Deflate.config_table[this.level].func != Deflate.config_table[n].func && zStream.total_in != 0L) {
            n3 = zStream.deflate(1);
        }
        if (this.level != n) {
            this.level = n;
            this.max_lazy_match = Deflate.config_table[this.level].max_lazy;
            this.good_match = Deflate.config_table[this.level].good_length;
            this.nice_match = Deflate.config_table[this.level].nice_length;
            this.max_chain_length = Deflate.config_table[this.level].max_chain;
        }
        this.strategy = n2;
        return n3;
    }

    int deflateSetDictionary(ZStream zStream, byte[] byArray, int n) {
        int n2 = n;
        int n3 = 0;
        if (byArray == null || this.status != 42) {
            return -2;
        }
        zStream.adler = zStream._adler.adler32(zStream.adler, byArray, 0, n);
        if (n2 < 3) {
            return 0;
        }
        if (n2 > this.w_size - 262) {
            n2 = this.w_size - 262;
            n3 = n - n2;
        }
        System.arraycopy(byArray, n3, this.window, 0, n2);
        this.strstart = n2;
        this.block_start = n2;
        this.ins_h = this.window[0] & 0xFF;
        this.ins_h = (this.ins_h << this.hash_shift ^ this.window[1] & 0xFF) & this.hash_mask;
        for (int i = 0; i <= n2 - 3; ++i) {
            this.ins_h = (this.ins_h << this.hash_shift ^ this.window[i + 2] & 0xFF) & this.hash_mask;
            this.prev[i & this.w_mask] = this.head[this.ins_h];
            this.head[this.ins_h] = (short)i;
        }
        return 0;
    }

    int deflate(ZStream zStream, int n) {
        int n2;
        int n3;
        if (n > 4 || n < 0) {
            return -2;
        }
        if (zStream.next_out == null || zStream.next_in == null && zStream.avail_in != 0 || this.status == 666 && n != 4) {
            zStream.msg = z_errmsg[4];
            return -2;
        }
        if (zStream.avail_out == 0) {
            zStream.msg = z_errmsg[7];
            return -5;
        }
        this.strm = zStream;
        int n4 = this.last_flush;
        this.last_flush = n;
        if (this.status == 42) {
            n3 = 8 + (this.w_bits - 8 << 4) << 8;
            n2 = (this.level - 1 & 0xFF) >> 1;
            if (n2 > 3) {
                n2 = 3;
            }
            n3 |= n2 << 6;
            if (this.strstart != 0) {
                n3 |= 0x20;
            }
            n3 += 31 - n3 % 31;
            this.status = 113;
            this.putShortMSB(n3);
            if (this.strstart != 0) {
                this.putShortMSB((int)(zStream.adler >>> 16));
                this.putShortMSB((int)(zStream.adler & 0xFFFFL));
            }
            zStream.adler = zStream._adler.adler32(0L, null, 0, 0);
        }
        if (this.pending != 0) {
            zStream.flush_pending();
            if (zStream.avail_out == 0) {
                this.last_flush = -1;
                return 0;
            }
        } else if (zStream.avail_in == 0 && n <= n4 && n != 4) {
            zStream.msg = z_errmsg[7];
            return -5;
        }
        if (this.status == 666 && zStream.avail_in != 0) {
            zStream.msg = z_errmsg[7];
            return -5;
        }
        if (zStream.avail_in != 0 || this.lookahead != 0 || n != 0 && this.status != 666) {
            n3 = -1;
            switch (Deflate.config_table[this.level].func) {
                case 0: {
                    n3 = this.deflate_stored(n);
                    break;
                }
                case 1: {
                    n3 = this.deflate_fast(n);
                    break;
                }
                case 2: {
                    n3 = this.deflate_slow(n);
                    break;
                }
            }
            if (n3 == 2 || n3 == 3) {
                this.status = 666;
            }
            if (n3 == 0 || n3 == 2) {
                if (zStream.avail_out == 0) {
                    this.last_flush = -1;
                }
                return 0;
            }
            if (n3 == 1) {
                if (n == 1) {
                    this._tr_align();
                } else {
                    this._tr_stored_block(0, 0, false);
                    if (n == 3) {
                        for (n2 = 0; n2 < this.hash_size; ++n2) {
                            this.head[n2] = 0;
                        }
                    }
                }
                zStream.flush_pending();
                if (zStream.avail_out == 0) {
                    this.last_flush = -1;
                    return 0;
                }
            }
        }
        if (n != 4) {
            return 0;
        }
        if (this.noheader != 0) {
            return 1;
        }
        this.putShortMSB((int)(zStream.adler >>> 16));
        this.putShortMSB((int)(zStream.adler & 0xFFFFL));
        zStream.flush_pending();
        this.noheader = -1;
        return this.pending != 0 ? 0 : 1;
    }

    static class Config {
        int good_length;
        int max_lazy;
        int nice_length;
        int max_chain;
        int func;

        Config(int n, int n2, int n3, int n4, int n5) {
            this.good_length = n;
            this.max_lazy = n2;
            this.nice_length = n3;
            this.max_chain = n4;
            this.func = n5;
        }
    }
}

