/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TIntHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TIntHashSet _set;

    public TIntHashSetDecorator(TIntHashSet tIntHashSet) {
        this._set = tIntHashSet;
    }

    public Object clone() {
        try {
            TIntHashSetDecorator tIntHashSetDecorator = (TIntHashSetDecorator)super.clone();
            tIntHashSetDecorator._set = (TIntHashSet)this._set.clone();
            return tIntHashSetDecorator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean add(Object object) {
        return this._set.add(this.unwrap(object));
    }

    public boolean equals(Object object) {
        if (this._set.equals(object)) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (set.size() != this._set.size()) {
                return false;
            }
            Iterator iterator = set.iterator();
            int n = set.size();
            while (n-- > 0) {
                Object e = iterator.next();
                if (e instanceof Integer) {
                    int n2 = this.unwrap(e);
                    if (this._set.contains(n2)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object object) {
        return this._set.remove(this.unwrap(object));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TIntIterator it;
            {
                this.it = TIntHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TIntHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Integer wrap(int n) {
        return new Integer(n);
    }

    protected int unwrap(Object object) {
        return (Integer)object;
    }
}

