/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongProcedure;
import gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TLongHash
extends TPrimitiveHash
implements Serializable,
TLongHashingStrategy {
    protected transient long[] _set;
    protected TLongHashingStrategy _hashingStrategy;

    public TLongHash() {
        this._hashingStrategy = this;
    }

    public TLongHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public TLongHash(int n, float f) {
        super(n, f);
        this._hashingStrategy = this;
    }

    public TLongHash(TLongHashingStrategy tLongHashingStrategy) {
        this._hashingStrategy = tLongHashingStrategy;
    }

    public TLongHash(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n);
        this._hashingStrategy = tLongHashingStrategy;
    }

    public TLongHash(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f);
        this._hashingStrategy = tLongHashingStrategy;
    }

    public Object clone() {
        TLongHash tLongHash = (TLongHash)super.clone();
        tLongHash._set = (long[])this._set.clone();
        return tLongHash;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new long[n2];
        return n2;
    }

    public boolean contains(long l) {
        return this.index(l) >= 0;
    }

    public boolean forEach(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._set[n] = 0L;
    }

    protected int index(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
            int n4 = 1 + n2 % (n - 2);
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l));
        }
        return byArray[n3] == 0 ? -1 : n3;
    }

    protected int insertionIndex(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] == 0) {
            return n3;
        }
        if (byArray[n3] == 1 && lArray[n3] == l) {
            return -n3 - 1;
        }
        int n4 = 1 + n2 % (n - 2);
        if (byArray[n3] != 2) {
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] == 1 && lArray[n3] != l);
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            return byArray[n3] == 1 ? -n3 - 1 : n5;
        }
        return byArray[n3] == 1 ? -n3 - 1 : n3;
    }

    public final int computeHashCode(long l) {
        return HashFunctions.hash(l);
    }
}

