/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntLongIterator;
import gnu.trove.TIntLongProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntLongHashMap
extends TIntHash
implements Serializable {
    protected transient long[] _values;

    public TIntLongHashMap() {
    }

    public TIntLongHashMap(int n) {
        super(n);
    }

    public TIntLongHashMap(int n, float f) {
        super(n, f);
    }

    public TIntLongHashMap(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntLongHashMap(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntLongHashMap(int n, float f, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f, tIntHashingStrategy);
    }

    public Object clone() {
        TIntLongHashMap tIntLongHashMap = (TIntLongHashMap)super.clone();
        tIntLongHashMap._values = (long[])this._values.clone();
        return tIntLongHashMap;
    }

    public TIntLongIterator iterator() {
        return new TIntLongIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new long[n2];
        return n2;
    }

    public long put(int n, long l) {
        long l2 = 0L;
        int n2 = this.insertionIndex(n);
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            l2 = this._values[n2];
            bl = false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this._values[n2] = l;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return l2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._values[n5] = lArray[n3];
            this._states[n5] = 1;
        }
    }

    public long get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? 0L : this._values[n2];
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            lArray[n] = 0L;
            byArray[n] = 0;
        }
    }

    public long remove(int n) {
        long l = 0L;
        int n2 = this.index(n);
        if (n2 >= 0) {
            l = this._values[n2];
            this.removeAt(n2);
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntLongHashMap)) {
            return false;
        }
        TIntLongHashMap tIntLongHashMap = (TIntLongHashMap)object;
        if (tIntLongHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tIntLongHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0L;
    }

    public long[] getValues() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public boolean containsValue(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || l != lArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        return this.contains(n);
    }

    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    public boolean forEachValue(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntLongProcedure tIntLongProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        long[] lArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntLongProcedure.execute(nArray[n], lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntLongProcedure tIntLongProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        long[] lArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntLongProcedure.execute(nArray[n], lArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TLongFunction tLongFunction) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n] = tLongFunction.execute(lArray[n]);
        }
    }

    public boolean increment(int n) {
        return this.adjustValue(n, 1L);
    }

    public boolean adjustValue(int n, long l) {
        int n2 = this.index(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + l;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            long l = objectInputStream.readLong();
            this.put(n2, l);
        }
    }

    private static final class EqProcedure
    implements TIntLongProcedure {
        private final TIntLongHashMap _otherMap;

        EqProcedure(TIntLongHashMap tIntLongHashMap) {
            this._otherMap = tIntLongHashMap;
        }

        public final boolean execute(int n, long l) {
            int n2 = this._otherMap.index(n);
            return n2 >= 0 && this.eq(l, this._otherMap.get(n));
        }

        private final boolean eq(long l, long l2) {
            return l == l2;
        }
    }

    private final class HashProcedure
    implements TIntLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(int n, long l) {
            this.h += TIntLongHashMap.this._hashingStrategy.computeHashCode(n) ^ HashFunctions.hash(l);
            return true;
        }
    }
}

