/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntProcedure;
import gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TIntHash
extends TPrimitiveHash
implements Serializable,
TIntHashingStrategy {
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy;

    public TIntHash() {
        this._hashingStrategy = this;
    }

    public TIntHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public TIntHash(int n, float f) {
        super(n, f);
        this._hashingStrategy = this;
    }

    public TIntHash(TIntHashingStrategy tIntHashingStrategy) {
        this._hashingStrategy = tIntHashingStrategy;
    }

    public TIntHash(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n);
        this._hashingStrategy = tIntHashingStrategy;
    }

    public TIntHash(int n, float f, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f);
        this._hashingStrategy = tIntHashingStrategy;
    }

    public Object clone() {
        TIntHash tIntHash = (TIntHash)super.clone();
        tIntHash._set = (int[])this._set.clone();
        return tIntHash;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new int[n2];
        return n2;
    }

    public boolean contains(int n) {
        return this.index(n) >= 0;
    }

    public boolean forEach(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._set[n] = 0;
    }

    protected int index(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = this._hashingStrategy.computeHashCode(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        if (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
            int n5 = 1 + n3 % (n2 - 2);
            do {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            } while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n));
        }
        return byArray[n4] == 0 ? -1 : n4;
    }

    protected int insertionIndex(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = this._hashingStrategy.computeHashCode(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1 && nArray[n4] == n) {
            return -n4 - 1;
        }
        int n5 = 1 + n3 % (n2 - 2);
        if (byArray[n4] != 2) {
            do {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            } while (byArray[n4] == 1 && nArray[n4] != n);
        }
        if (byArray[n4] == 2) {
            int n6 = n4;
            while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            }
            return byArray[n4] == 1 ? -n4 - 1 : n6;
        }
        return byArray[n4] == 1 ? -n4 - 1 : n4;
    }

    public final int computeHashCode(int n) {
        return HashFunctions.hash(n);
    }
}

