/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatObjectIterator;
import gnu.trove.TFloatObjectProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatObjectHashMap
extends TFloatHash
implements Serializable {
    protected transient Object[] _values;

    public TFloatObjectHashMap() {
    }

    public TFloatObjectHashMap(int n) {
        super(n);
    }

    public TFloatObjectHashMap(int n, float f) {
        super(n, f);
    }

    public TFloatObjectHashMap(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatObjectHashMap(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatObjectHashMap(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public Object clone() {
        TFloatObjectHashMap tFloatObjectHashMap = (TFloatObjectHashMap)super.clone();
        tFloatObjectHashMap._values = (Object[])this._values.clone();
        return tFloatObjectHashMap;
    }

    public TFloatObjectIterator iterator() {
        return new TFloatObjectIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(float f, Object object) {
        Object object2 = null;
        int n = this.insertionIndex(f);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = f;
        this._states[n] = 1;
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return object2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._values[n4] = objectArray[n3];
            this._states[n4] = 1;
        }
    }

    public Object get(float f) {
        int n = this.index(f);
        return n < 0 ? null : this._values[n];
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            objectArray[n] = null;
            byArray[n] = 0;
        }
    }

    public Object remove(float f) {
        Object object = null;
        int n = this.index(f);
        if (n >= 0) {
            object = this._values[n];
            this.removeAt(n);
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatObjectHashMap)) {
            return false;
        }
        TFloatObjectHashMap tFloatObjectHashMap = (TFloatObjectHashMap)object;
        if (tFloatObjectHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tFloatObjectHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public float[] keys() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float f) {
        return this.contains(f);
    }

    public boolean forEachKey(TFloatProcedure tFloatProcedure) {
        return this.forEach(tFloatProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatObjectProcedure tFloatObjectProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        Object[] objectArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatObjectProcedure.execute(fArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatObjectProcedure tFloatObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        float[] fArray = this._set;
        Object[] objectArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatObjectProcedure.execute(fArray[n], objectArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            Object object = objectInputStream.readObject();
            this.put(f, object);
        }
    }

    private static final class EqProcedure
    implements TFloatObjectProcedure {
        private final TFloatObjectHashMap _otherMap;

        EqProcedure(TFloatObjectHashMap tFloatObjectHashMap) {
            this._otherMap = tFloatObjectHashMap;
        }

        public final boolean execute(float f, Object object) {
            int n = this._otherMap.index(f);
            return n >= 0 && this.eq(object, this._otherMap.get(f));
        }

        private final boolean eq(Object object, Object object2) {
            return object == object2 || object != null && object.equals(object2);
        }
    }

    private final class HashProcedure
    implements TFloatObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f, Object object) {
            this.h += TFloatObjectHashMap.this._hashingStrategy.computeHashCode(f) ^ HashFunctions.hash(object);
            return true;
        }
    }
}

