/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatFloatIterator;
import gnu.trove.TFloatFloatProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatFloatHashMap
extends TFloatHash
implements Serializable {
    protected transient float[] _values;

    public TFloatFloatHashMap() {
    }

    public TFloatFloatHashMap(int n) {
        super(n);
    }

    public TFloatFloatHashMap(int n, float f) {
        super(n, f);
    }

    public TFloatFloatHashMap(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatFloatHashMap(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatFloatHashMap(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public Object clone() {
        TFloatFloatHashMap tFloatFloatHashMap = (TFloatFloatHashMap)super.clone();
        tFloatFloatHashMap._values = (float[])this._values.clone();
        return tFloatFloatHashMap;
    }

    public TFloatFloatIterator iterator() {
        return new TFloatFloatIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new float[n2];
        return n2;
    }

    public float put(float f, float f2) {
        float f3 = 0.0f;
        int n = this.insertionIndex(f);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            f3 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = f;
        this._states[n] = 1;
        this._values[n] = f2;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return f3;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._values = new float[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._values[n4] = fArray2[n3];
            this._states[n4] = 1;
        }
    }

    public float get(float f) {
        int n = this.index(f);
        return n < 0 ? 0.0f : this._values[n];
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            fArray2[n] = 0.0f;
            byArray[n] = 0;
        }
    }

    public float remove(float f) {
        float f2 = 0.0f;
        int n = this.index(f);
        if (n >= 0) {
            f2 = this._values[n];
            this.removeAt(n);
        }
        return f2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatFloatHashMap)) {
            return false;
        }
        TFloatFloatHashMap tFloatFloatHashMap = (TFloatFloatHashMap)object;
        if (tFloatFloatHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tFloatFloatHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0f;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public float[] keys() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public boolean containsValue(float f) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || f != fArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float f) {
        return this.contains(f);
    }

    public boolean forEachKey(TFloatProcedure tFloatProcedure) {
        return this.forEach(tFloatProcedure);
    }

    public boolean forEachValue(TFloatProcedure tFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatFloatProcedure tFloatFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        float[] fArray2 = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatFloatProcedure.execute(fArray[n], fArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatFloatProcedure tFloatFloatProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        float[] fArray = this._set;
        float[] fArray2 = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatFloatProcedure.execute(fArray[n], fArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n] = tFloatFunction.execute(fArray[n]);
        }
    }

    public boolean increment(float f) {
        return this.adjustValue(f, 1.0f);
    }

    public boolean adjustValue(float f, float f2) {
        int n = this.index(f);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + f2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            float f2 = objectInputStream.readFloat();
            this.put(f, f2);
        }
    }

    private static final class EqProcedure
    implements TFloatFloatProcedure {
        private final TFloatFloatHashMap _otherMap;

        EqProcedure(TFloatFloatHashMap tFloatFloatHashMap) {
            this._otherMap = tFloatFloatHashMap;
        }

        public final boolean execute(float f, float f2) {
            int n = this._otherMap.index(f);
            return n >= 0 && this.eq(f2, this._otherMap.get(f));
        }

        private final boolean eq(float f, float f2) {
            return f == f2;
        }
    }

    private final class HashProcedure
    implements TFloatFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f, float f2) {
            this.h += TFloatFloatHashMap.this._hashingStrategy.computeHashCode(f) ^ HashFunctions.hash(f2);
            return true;
        }
    }
}

