/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TFloatDoubleIterator;
import gnu.trove.TFloatDoubleProcedure;
import gnu.trove.TFloatHash;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TFloatDoubleHashMap
extends TFloatHash
implements Serializable {
    protected transient double[] _values;

    public TFloatDoubleHashMap() {
    }

    public TFloatDoubleHashMap(int n) {
        super(n);
    }

    public TFloatDoubleHashMap(int n, float f) {
        super(n, f);
    }

    public TFloatDoubleHashMap(TFloatHashingStrategy tFloatHashingStrategy) {
        super(tFloatHashingStrategy);
    }

    public TFloatDoubleHashMap(int n, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, tFloatHashingStrategy);
    }

    public TFloatDoubleHashMap(int n, float f, TFloatHashingStrategy tFloatHashingStrategy) {
        super(n, f, tFloatHashingStrategy);
    }

    public Object clone() {
        TFloatDoubleHashMap tFloatDoubleHashMap = (TFloatDoubleHashMap)super.clone();
        tFloatDoubleHashMap._values = (double[])this._values.clone();
        return tFloatDoubleHashMap;
    }

    public TFloatDoubleIterator iterator() {
        return new TFloatDoubleIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new double[n2];
        return n2;
    }

    public double put(float f, double d) {
        double d2 = 0.0;
        int n = this.insertionIndex(f);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            d2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = f;
        this._states[n] = 1;
        this._values[n] = d;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return d2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        float[] fArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        this._set = new float[n];
        this._values = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.insertionIndex(f);
            this._set[n4] = f;
            this._values[n4] = dArray[n3];
            this._states[n4] = 1;
        }
    }

    public double get(float f) {
        int n = this.index(f);
        return n < 0 ? 0.0 : this._values[n];
    }

    public void clear() {
        super.clear();
        float[] fArray = this._set;
        double[] dArray = this._values;
        byte[] byArray = this._states;
        int n = fArray.length;
        while (n-- > 0) {
            fArray[n] = 0.0f;
            dArray[n] = 0.0;
            byArray[n] = 0;
        }
    }

    public double remove(float f) {
        double d = 0.0;
        int n = this.index(f);
        if (n >= 0) {
            d = this._values[n];
            this.removeAt(n);
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TFloatDoubleHashMap)) {
            return false;
        }
        TFloatDoubleHashMap tFloatDoubleHashMap = (TFloatDoubleHashMap)object;
        if (tFloatDoubleHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tFloatDoubleHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0;
    }

    public double[] getValues() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public float[] keys() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._set;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public boolean containsValue(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || d != dArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float f) {
        return this.contains(f);
    }

    public boolean forEachKey(TFloatProcedure tFloatProcedure) {
        return this.forEach(tFloatProcedure);
    }

    public boolean forEachValue(TDoubleProcedure tDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatDoubleProcedure tFloatDoubleProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._set;
        double[] dArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatDoubleProcedure.execute(fArray[n], dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatDoubleProcedure tFloatDoubleProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        float[] fArray = this._set;
        double[] dArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatDoubleProcedure.execute(fArray[n], dArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n] = tDoubleFunction.execute(dArray[n]);
        }
    }

    public boolean increment(float f) {
        return this.adjustValue(f, 1.0);
    }

    public boolean adjustValue(float f, double d) {
        int n = this.index(f);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + d;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            float f = objectInputStream.readFloat();
            double d = objectInputStream.readDouble();
            this.put(f, d);
        }
    }

    private static final class EqProcedure
    implements TFloatDoubleProcedure {
        private final TFloatDoubleHashMap _otherMap;

        EqProcedure(TFloatDoubleHashMap tFloatDoubleHashMap) {
            this._otherMap = tFloatDoubleHashMap;
        }

        public final boolean execute(float f, double d) {
            int n = this._otherMap.index(f);
            return n >= 0 && this.eq(d, this._otherMap.get(f));
        }

        private final boolean eq(double d, double d2) {
            return d == d2;
        }
    }

    private final class HashProcedure
    implements TFloatDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(float f, double d) {
            this.h += TFloatDoubleHashMap.this._hashingStrategy.computeHashCode(f) ^ HashFunctions.hash(d);
            return true;
        }
    }
}

