/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleLongIterator;
import gnu.trove.TDoubleLongProcedure;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TDoubleLongHashMap
extends TDoubleHash
implements Serializable {
    protected transient long[] _values;

    public TDoubleLongHashMap() {
    }

    public TDoubleLongHashMap(int n) {
        super(n);
    }

    public TDoubleLongHashMap(int n, float f) {
        super(n, f);
    }

    public TDoubleLongHashMap(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleLongHashMap(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleLongHashMap(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public Object clone() {
        TDoubleLongHashMap tDoubleLongHashMap = (TDoubleLongHashMap)super.clone();
        tDoubleLongHashMap._values = (long[])this._values.clone();
        return tDoubleLongHashMap;
    }

    public TDoubleLongIterator iterator() {
        return new TDoubleLongIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new long[n2];
        return n2;
    }

    public long put(double d, long l) {
        long l2 = 0L;
        int n = this.insertionIndex(d);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            l2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = d;
        this._states[n] = 1;
        this._values[n] = l;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return l2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._values = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._values[n4] = lArray[n3];
            this._states[n4] = 1;
        }
    }

    public long get(double d) {
        int n = this.index(d);
        return n < 0 ? 0L : this._values[n];
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        long[] lArray = this._values;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            lArray[n] = 0L;
            byArray[n] = 0;
        }
    }

    public long remove(double d) {
        long l = 0L;
        int n = this.index(d);
        if (n >= 0) {
            l = this._values[n];
            this.removeAt(n);
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleLongHashMap)) {
            return false;
        }
        TDoubleLongHashMap tDoubleLongHashMap = (TDoubleLongHashMap)object;
        if (tDoubleLongHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tDoubleLongHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0L;
    }

    public long[] getValues() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public double[] keys() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public boolean containsValue(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || l != lArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(double d) {
        return this.contains(d);
    }

    public boolean forEachKey(TDoubleProcedure tDoubleProcedure) {
        return this.forEach(tDoubleProcedure);
    }

    public boolean forEachValue(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleLongProcedure tDoubleLongProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        long[] lArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleLongProcedure.execute(dArray[n], lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TDoubleLongProcedure tDoubleLongProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        double[] dArray = this._set;
        long[] lArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleLongProcedure.execute(dArray[n], lArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TLongFunction tLongFunction) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n] = tLongFunction.execute(lArray[n]);
        }
    }

    public boolean increment(double d) {
        return this.adjustValue(d, 1L);
    }

    public boolean adjustValue(double d, long l) {
        int n = this.index(d);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + l;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            long l = objectInputStream.readLong();
            this.put(d, l);
        }
    }

    private static final class EqProcedure
    implements TDoubleLongProcedure {
        private final TDoubleLongHashMap _otherMap;

        EqProcedure(TDoubleLongHashMap tDoubleLongHashMap) {
            this._otherMap = tDoubleLongHashMap;
        }

        public final boolean execute(double d, long l) {
            int n = this._otherMap.index(d);
            return n >= 0 && this.eq(l, this._otherMap.get(d));
        }

        private final boolean eq(long l, long l2) {
            return l == l2;
        }
    }

    private final class HashProcedure
    implements TDoubleLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d, long l) {
            this.h += TDoubleLongHashMap.this._hashingStrategy.computeHashCode(d) ^ HashFunctions.hash(l);
            return true;
        }
    }
}

