/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleIterator;
import gnu.trove.TDoubleProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TDoubleHashSet
extends TDoubleHash
implements Serializable {
    public TDoubleHashSet() {
    }

    public TDoubleHashSet(int n) {
        super(n);
    }

    public TDoubleHashSet(int n, float f) {
        super(n, f);
    }

    public TDoubleHashSet(double[] dArray) {
        this(dArray.length);
        this.addAll(dArray);
    }

    public TDoubleHashSet(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleHashSet(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleHashSet(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public TDoubleHashSet(double[] dArray, TDoubleHashingStrategy tDoubleHashingStrategy) {
        this(dArray.length, tDoubleHashingStrategy);
        this.addAll(dArray);
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(this);
    }

    public boolean add(double d) {
        int n = this.insertionIndex(d);
        if (n < 0) {
            return false;
        }
        byte by = this._states[n];
        this._set[n] = d;
        this._states[n] = 1;
        this.postInsertHook(by == 0);
        return true;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._states[n4] = 1;
        }
    }

    public double[] toArray() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            byArray[n] = 0;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleHashSet)) {
            return false;
        }
        final TDoubleHashSet tDoubleHashSet = (TDoubleHashSet)object;
        if (tDoubleHashSet.size() != this.size()) {
            return false;
        }
        return this.forEach(new TDoubleProcedure(){

            public final boolean execute(double d) {
                return tDoubleHashSet.contains(d);
            }
        });
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public boolean remove(double d) {
        int n = this.index(d);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public boolean containsAll(double[] dArray) {
        int n = dArray.length;
        while (n-- > 0) {
            if (this.contains(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(double[] dArray) {
        boolean bl = false;
        int n = dArray.length;
        while (n-- > 0) {
            if (!this.add(dArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(double[] dArray) {
        boolean bl = false;
        int n = dArray.length;
        while (n-- > 0) {
            if (!this.remove(dArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(double[] dArray) {
        boolean bl = false;
        Arrays.sort(dArray);
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(dArray, dArray2[n]) >= 0) continue;
            this.remove(dArray2[n]);
            bl = true;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            this.add(d);
        }
    }

    private final class HashProcedure
    implements TDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d) {
            this.h += TDoubleHashSet.this._hashingStrategy.computeHashCode(d);
            return true;
        }
    }
}

