/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleDoubleIterator;
import gnu.trove.TDoubleDoubleProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TDoubleDoubleHashMap
extends TDoubleHash
implements Serializable {
    protected transient double[] _values;

    public TDoubleDoubleHashMap() {
    }

    public TDoubleDoubleHashMap(int n) {
        super(n);
    }

    public TDoubleDoubleHashMap(int n, float f) {
        super(n, f);
    }

    public TDoubleDoubleHashMap(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleDoubleHashMap(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleDoubleHashMap(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public Object clone() {
        TDoubleDoubleHashMap tDoubleDoubleHashMap = (TDoubleDoubleHashMap)super.clone();
        tDoubleDoubleHashMap._values = (double[])this._values.clone();
        return tDoubleDoubleHashMap;
    }

    public TDoubleDoubleIterator iterator() {
        return new TDoubleDoubleIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new double[n2];
        return n2;
    }

    public double put(double d, double d2) {
        double d3 = 0.0;
        int n = this.insertionIndex(d);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            d3 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = d;
        this._states[n] = 1;
        this._values[n] = d2;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return d3;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._values = new double[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._values[n4] = dArray2[n3];
            this._states[n4] = 1;
        }
    }

    public double get(double d) {
        int n = this.index(d);
        return n < 0 ? 0.0 : this._values[n];
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            dArray2[n] = 0.0;
            byArray[n] = 0;
        }
    }

    public double remove(double d) {
        double d2 = 0.0;
        int n = this.index(d);
        if (n >= 0) {
            d2 = this._values[n];
            this.removeAt(n);
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleDoubleHashMap)) {
            return false;
        }
        TDoubleDoubleHashMap tDoubleDoubleHashMap = (TDoubleDoubleHashMap)object;
        if (tDoubleDoubleHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tDoubleDoubleHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0;
    }

    public double[] getValues() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public double[] keys() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public boolean containsValue(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || d != dArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(double d) {
        return this.contains(d);
    }

    public boolean forEachKey(TDoubleProcedure tDoubleProcedure) {
        return this.forEach(tDoubleProcedure);
    }

    public boolean forEachValue(TDoubleProcedure tDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleDoubleProcedure tDoubleDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        double[] dArray2 = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleDoubleProcedure.execute(dArray[n], dArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TDoubleDoubleProcedure tDoubleDoubleProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        double[] dArray = this._set;
        double[] dArray2 = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleDoubleProcedure.execute(dArray[n], dArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        byte[] byArray = this._states;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n] = tDoubleFunction.execute(dArray[n]);
        }
    }

    public boolean increment(double d) {
        return this.adjustValue(d, 1.0);
    }

    public boolean adjustValue(double d, double d2) {
        int n = this.index(d);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + d2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            double d2 = objectInputStream.readDouble();
            this.put(d, d2);
        }
    }

    private static final class EqProcedure
    implements TDoubleDoubleProcedure {
        private final TDoubleDoubleHashMap _otherMap;

        EqProcedure(TDoubleDoubleHashMap tDoubleDoubleHashMap) {
            this._otherMap = tDoubleDoubleHashMap;
        }

        public final boolean execute(double d, double d2) {
            int n = this._otherMap.index(d);
            return n >= 0 && this.eq(d2, this._otherMap.get(d));
        }

        private final boolean eq(double d, double d2) {
            return d == d2;
        }
    }

    private final class HashProcedure
    implements TDoubleDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d, double d2) {
            this.h += TDoubleDoubleHashMap.this._hashingStrategy.computeHashCode(d) ^ HashFunctions.hash(d2);
            return true;
        }
    }
}

