/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.vmware.api;

import java.io.UnsupportedEncodingException;

public class HostCredentials {
    private String m_host;
    private String m_username;
    private byte[] m_password;
    private byte[] m_rootPassword;
    private static final Encryptor ENCRYPTOR = new Encryptor(){

        public byte[] encode(String cleartext) {
            try {
                return cleartext == null ? null : cleartext.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String decode(byte[] encrypted) {
            try {
                return new String(encrypted, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public HostCredentials() {
    }

    public HostCredentials(String host, String username, String password, String rootPassword) {
        this.setHost(host);
        this.setUsername(username);
        this.setPassword(password);
        this.setRootPassword(rootPassword);
    }

    public boolean isValid() {
        return this.getHost() != null && this.getUsername() != null && this.m_password != null;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host == null ? null : host.trim();
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username == null ? null : username.trim();
    }

    public final String getPassword() {
        return null == this.m_password ? null : HostCredentials.getEncryptor().decode(this.m_password);
    }

    public final void setPassword(String password) {
        this.m_password = password == null ? null : HostCredentials.getEncryptor().encode(password.trim());
    }

    public final String getRootPassword() {
        return null == this.m_rootPassword ? null : HostCredentials.getEncryptor().decode(this.m_rootPassword);
    }

    public final void setRootPassword(String rootPassword) {
        this.m_rootPassword = rootPassword == null ? null : HostCredentials.getEncryptor().encode(rootPassword.trim());
    }

    public boolean isRootPasswordEmpty() {
        return this.m_rootPassword == null || this.m_rootPassword.length == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("host=").append(this.m_host);
        sb.append(";userid=").append(this.m_username);
        return sb.toString();
    }

    private static Encryptor getEncryptor() {
        return ENCRYPTOR;
    }

    public static interface Encryptor {
        public byte[] encode(String var1);

        public String decode(byte[] var1);
    }
}

