/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.vmware.api;

import com.tripwire.common.util.StringUtil;
import com.tripwire.vmware.api.HostCredentials;
import com.tripwire.vmware.api.HostSystem;
import com.tripwire.vmware.api.ServiceInstance;
import com.tripwire.vmware.api.Traversal;
import com.tripwire.vmware.api.Util;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.ArrayOfAlarmState;
import com.vmware.vim25.ArrayOfCustomFieldValue;
import com.vmware.vim25.ArrayOfDiagnosticManagerBundleInfo;
import com.vmware.vim25.ArrayOfEvent;
import com.vmware.vim25.ArrayOfInt;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.ArrayOfPermission;
import com.vmware.vim25.ArrayOfResourceConfigSpec;
import com.vmware.vim25.ArrayOfString;
import com.vmware.vim25.DiagnosticManagerBundleInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodFault;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.Permission;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyChangeOp;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.UpdateSet;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class EsxServer {
    private ServiceInstance m_service;
    private HostSystem m_hostSystem;
    private HostCredentials m_hostCredentials;
    String[][] typeInfo;

    public EsxServer(HostCredentials hostCredentials) throws Exception {
        this.initialize(hostCredentials);
    }

    public EsxServer(String host, String username, String password, String rootPassword) throws Exception {
        this.initialize(new HostCredentials(host, username, password, rootPassword));
    }

    protected void initialize(HostCredentials hostCredentials) throws Exception {
        this.setHostCredentials(hostCredentials);
        this.m_service = new ServiceInstance("https://" + hostCredentials.getHost() + "/sdk");
        if (StringUtil.notEmpty(hostCredentials.getRootPassword())) {
            this.m_service.login("root", hostCredentials.getRootPassword());
        } else {
            this.m_service.login(hostCredentials.getUsername(), hostCredentials.getPassword());
        }
        this.m_hostSystem = null;
    }

    public Version getVersion() throws Exception {
        AboutInfo about = this.m_service.getServiceContent().getAbout();
        Version version = new Version();
        version.setVersion(about.getVersion());
        version.setProductLineId(about.getProductLineId());
        version.setFullName(about.getFullName());
        version.setApiType(about.getApiType());
        version.setApiVersion(about.getApiVersion());
        version.setBuild(about.getBuild());
        version.setLocaleBuild(about.getLocaleBuild());
        version.setLocaleVersion(about.getLocaleVersion());
        version.setName(about.getName());
        version.setOsType(about.getOsType());
        version.setProductLineId(about.getProductLineId());
        version.setVendor(about.getVendor());
        version.setVersion(about.getVersion());
        return version;
    }

    public String getConfigBackup() throws Exception {
        String retString = null;
        HostSystem hostSystem = this.getHostSystem();
        DynamicProperty dynamicProperty = hostSystem.getProperty("configManager");
        if (null != dynamicProperty) {
            HostConfigManager hostConfigManager = (HostConfigManager)dynamicProperty.getVal();
            ManagedObjectReference mor = hostConfigManager.getFirmwareSystem();
            if (null != mor) {
                retString = this.m_service.backupFirmwareConfiguration(mor);
                if (null != retString) {
                    retString = retString.replace("*", this.getHostCredentials().getHost());
                }
                if (null != retString) {
                    retString = retString.replace("http", "https");
                }
            } else {
                System.out.println("missing firmwareSystem");
            }
        } else {
            System.out.println("missing configManager");
        }
        return retString;
    }

    protected void updateValues(String[] props, Object[] vals, PropertyChange propchg) {
        for (int findi = 0; findi < props.length; ++findi) {
            if (propchg.getName().lastIndexOf(props[findi]) < 0) continue;
            vals[findi] = propchg.getOp() == PropertyChangeOp.remove ? "" : propchg.getVal();
        }
    }

    public Object[] waitForValues(ManagedObjectReference objmor, String[] filterProps, String[] endWaitProps, Object[][] expectedVals) throws Exception {
        String version = "";
        Object[] endVals = new Object[endWaitProps.length];
        Object[] filterVals = new Object[filterProps.length];
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(objmor);
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setPathSet(filterProps);
        spec.getPropSet(0).setType(objmor.getType());
        spec.getObjectSet(0).setSelectSet(null);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        ManagedObjectReference filterSpecRef = this.m_service.getService().createFilter(this.m_service.getPropCol(), spec, true);
        boolean reached = false;
        UpdateSet updateset = null;
        PropertyFilterUpdate[] filtupary = null;
        PropertyFilterUpdate filtup = null;
        ObjectUpdate[] objupary = null;
        ObjectUpdate objup = null;
        PropertyChange[] propchgary = null;
        PropertyChange propchg = null;
        while (!reached) {
            boolean retry = true;
            while (retry) {
                try {
                    updateset = this.m_service.getService().waitForUpdates(this.m_service.getPropCol(), version);
                    retry = false;
                }
                catch (Exception e) {
                    if (!(e instanceof AxisFault)) continue;
                    AxisFault fault = (AxisFault)e;
                    Element[] errors = fault.getFaultDetails();
                    String faultString = fault.getFaultString();
                    if (faultString.indexOf("java.net.SocketTimeoutException") != -1) {
                        System.out.println("Retrying2........");
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            }
            version = updateset.getVersion();
            if (updateset == null || updateset.getFilterSet() == null) continue;
            filtupary = updateset.getFilterSet();
            filtup = null;
            for (int fi = 0; fi < filtupary.length; ++fi) {
                filtup = filtupary[fi];
                objupary = filtup.getObjectSet();
                objup = null;
                propchgary = null;
                for (int oi = 0; oi < objupary.length; ++oi) {
                    objup = objupary[oi];
                    if (objup.getKind() != ObjectUpdateKind.modify && objup.getKind() != ObjectUpdateKind.enter && objup.getKind() != ObjectUpdateKind.leave) continue;
                    propchgary = objup.getChangeSet();
                    for (int ci = 0; ci < propchgary.length; ++ci) {
                        propchg = propchgary[ci];
                        this.updateValues(endWaitProps, endVals, propchg);
                        this.updateValues(filterProps, filterVals, propchg);
                    }
                }
            }
            Object expctdval = null;
            for (int chgi = 0; chgi < endVals.length && !reached; ++chgi) {
                for (int vali = 0; vali < expectedVals[chgi].length && !reached; ++vali) {
                    expctdval = expectedVals[chgi][vali];
                    reached = expctdval.equals(endVals[chgi]) || reached;
                }
            }
        }
        this.m_service.getService().destroyPropertyFilter(filterSpecRef);
        return filterVals;
    }

    public ObjectContent[] getObjectProperties(ManagedObjectReference collector, ManagedObjectReference mobj, String[] properties) throws Exception {
        if (mobj == null) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this.m_service.getPropCol();
        }
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setPropSet(new PropertySpec[]{new PropertySpec()});
        spec.getPropSet(0).setAll(new Boolean(properties == null || properties.length == 0));
        spec.getPropSet(0).setType(mobj.getType());
        spec.getPropSet(0).setPathSet(properties);
        spec.setObjectSet(new ObjectSpec[]{new ObjectSpec()});
        spec.getObjectSet(0).setObj(mobj);
        spec.getObjectSet(0).setSkip(Boolean.FALSE);
        return this.m_service.getService().retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
    }

    boolean methodExists(Object obj, String methodName, Class[] parameterTypes) {
        boolean exists = false;
        try {
            Method method = obj.getClass().getMethod(methodName, parameterTypes);
            if (method != null) {
                exists = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return exists;
    }

    public Object getDynamicProperty(ManagedObjectReference mor, String propertyName) throws Exception {
        DynamicProperty[] dynamicProperty;
        ObjectContent[] objContent = this.getObjectProperties(null, mor, new String[]{propertyName});
        Object propertyValue = null;
        if (objContent != null && (dynamicProperty = objContent[0].getPropSet()) != null) {
            Object dynamicPropertyVal = dynamicProperty[0].getVal();
            String dynamicPropertyName = dynamicPropertyVal.getClass().getName();
            if (dynamicPropertyName.indexOf("ArrayOf") != -1) {
                String methodName = dynamicPropertyName.substring(dynamicPropertyName.indexOf("ArrayOf") + "ArrayOf".length(), dynamicPropertyName.length());
                methodName = this.methodExists(dynamicPropertyVal, "get" + methodName, null) ? "get" + methodName : "get_" + methodName.toLowerCase();
                Method getMorMethod = dynamicPropertyVal.getClass().getDeclaredMethod(methodName, null);
                propertyValue = getMorMethod.invoke(dynamicPropertyVal, (Object[])null);
            } else {
                propertyValue = dynamicPropertyVal.getClass().isArray() ? dynamicPropertyVal : dynamicPropertyVal;
            }
        }
        return propertyValue;
    }

    public String waitForTask(ManagedObjectReference taskmor) throws Exception {
        Object[] result = this.waitForValues(taskmor, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.success, TaskInfoState.error}});
        if (result[0].equals(TaskInfoState.success)) {
            return "success";
        }
        TaskInfo tinfo = (TaskInfo)this.getDynamicProperty(taskmor, "info");
        LocalizedMethodFault fault = tinfo.getError();
        String error = "Error Occured";
        if (fault != null) {
            MethodFault methodFault = fault.getFault();
            if (null == methodFault) {
                System.out.println("waitForTask: LocalizedMessage=" + fault.getLocalizedMessage());
                error = fault.getLocalizedMessage();
            } else {
                System.out.println("waitForTask: LocalizedMessage=" + fault.getLocalizedMessage() + ";FaultActor=" + methodFault.getFaultActor() + ";FaultDetails=" + methodFault.getFaultDetails() + ";FaultNode=" + methodFault.getFaultNode() + ";FaultReason=" + methodFault.getFaultReason() + ";FaultRole=" + methodFault.getFaultRole() + ";FaultString=" + methodFault.getFaultString() + ";Message=" + methodFault.getMessage() + ";FaultCode=" + methodFault.getFaultCode());
                error = methodFault.getFaultReason();
            }
        }
        return error;
    }

    public String getLogBundles() throws Exception {
        String url = null;
        ServiceContent serviceContent = this.m_service.getServiceContent();
        ManagedObjectReference mor = serviceContent.getDiagnosticManager();
        ManagedObjectReference taskmor = this.m_service.generateLogBundles_Task(mor, true, null);
        String waitStatus = this.waitForTask(taskmor);
        TaskInfo taskInfo = (TaskInfo)this.getDynamicProperty(taskmor, "info");
        Object result = taskInfo.getResult();
        if (null == result) {
            System.out.println("Couldn't get log bundles task info for some reason, perhaps task was already started");
        } else {
            ArrayOfDiagnosticManagerBundleInfo results = (ArrayOfDiagnosticManagerBundleInfo)result;
            DiagnosticManagerBundleInfo[] dmbi = results.getDiagnosticManagerBundleInfo();
            for (int ii = 0; ii < dmbi.length; ++ii) {
                System.out.println("dmbi str=" + dmbi[ii].getUrl());
                url = dmbi[0].getUrl();
            }
            if (null != url) {
                url = url.replace("*", this.getHostCredentials().getHost());
            }
        }
        return url;
    }

    public HostSystem getHostSystem() throws Exception {
        if (this.m_hostSystem == null) {
            this.m_hostSystem = this.searchForHostSystem();
        }
        return this.m_hostSystem;
    }

    public String getCookie() {
        String cookie = null;
        try {
            cookie = this.m_service.getCookie();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookie;
    }

    private HostSystem searchForHostSystem() throws Exception {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.TRUE);
        propertySpec.setType("HostSystem");
        Traversal folderTraversal = new Traversal("folderTraversal", "Folder", "childEntity");
        Traversal resourcePoolTraversal = new Traversal("resourcePoolTraversal", "ResourcePool", "resourcePool");
        resourcePoolTraversal.makeRecursive();
        folderTraversal.addChildTraversal(resourcePoolTraversal);
        Traversal datacenterHostTraversal = new Traversal("datacenterHostTraversal", "Datacenter", "hostFolder");
        datacenterHostTraversal.addChildTraversalReference(folderTraversal);
        folderTraversal.addChildTraversal(datacenterHostTraversal);
        Traversal computeResourceHostTraversal = new Traversal("computeResourceHostTraversal", "ComputeResource", "host");
        folderTraversal.addChildTraversal(computeResourceHostTraversal);
        SelectionSpec[] allTraversalSpecs = new SelectionSpec[]{folderTraversal.getSpec()};
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.m_service.getRootFolder());
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.setSelectSet(allTraversalSpecs);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.setPropSet(new PropertySpec[]{propertySpec});
        propertyFilterSpec.setObjectSet(new ObjectSpec[]{objectSpec});
        PropertyFilterSpec[] propertyFilterSpecs = new PropertyFilterSpec[]{propertyFilterSpec};
        ObjectContent[] objects = this.m_service.retrieveProperties(propertyFilterSpecs);
        Util.validateOne(objects.length);
        return new HostSystem(this.m_service, objects[0]);
    }

    public void close() throws Exception {
        this.m_service.logout();
    }

    public HostCredentials getHostCredentials() {
        return this.m_hostCredentials;
    }

    public void setHostCredentials(HostCredentials hostCredentials) {
        this.m_hostCredentials = hostCredentials;
    }

    public ObjectContent[] getContentsRecursively(ManagedObjectReference collector, ManagedObjectReference root, String[][] typeinfo, boolean recurse) throws Exception {
        ManagedObjectReference useroot;
        if (typeinfo == null || typeinfo.length == 0) {
            return null;
        }
        ManagedObjectReference usecoll = collector;
        if (usecoll == null) {
            usecoll = this.m_service.getPropCol();
        }
        if ((useroot = root) == null) {
            useroot = this.m_service.getRootFolder();
        }
        SelectionSpec[] selectionSpecs = null;
        if (recurse) {
            selectionSpecs = this.buildFullTraversal();
        }
        PropertySpec[] propspecary = this.buildPropertySpecArray(typeinfo);
        PropertyFilterSpec spec = new PropertyFilterSpec(null, null, propspecary, new ObjectSpec[]{new ObjectSpec(null, null, useroot, Boolean.FALSE, selectionSpecs)});
        ObjectContent[] retoc = this.m_service.getService().retrieveProperties(usecoll, new PropertyFilterSpec[]{spec});
        return retoc;
    }

    public void retrieveContents() throws Exception {
        try {
            this.typeInfo = new String[][]{{"ManagedEntity", "name"}, {"Alarm", "info"}, {"AlarmManager", "description"}, {"AuthorizationManager", "description"}, {"ClusterComputeResource", "configuration"}, {"CustomFieldsManager", "field"}, {"CustomizationSpecManager", "encryptionKey"}, {"Datastore", "browser"}, {"EnvironmentBrowser", "datastoreBrowser"}, {"EventHistoryCollector", "latestPage"}, {"EventManager", "description"}, {"HistoryCollector", "filter"}, {"HostAutoStartManager", "config"}, {"HostCpuSchedulerSystem", "hyperthreadInfo"}, {"HostDatastoreBrowser", "datastore"}, {"HostDatastoreSystem", "datastore"}, {"ManagedEntity", "configStatus"}, {"ManagedEntity", "configIssue"}, {"ManagedEntity", "customValue"}, {"ManagedEntity", "declaredAlarmState"}, {"ManagedEntity", "disabledMethod"}, {"ManagedEntity", "effectiveRole"}, {"ManagedEntity", "overallStatus"}, {"ManagedEntity", "parent"}, {"ManagedEntity", "permission"}, {"ManagedEntity", "recentTask"}, {"ManagedEntity", "triggeredAlarmState"}, {"ComputeResource", "datastore"}, {"ComputeResource", "environmentBrowser"}, {"ComputeResource", "host"}, {"ComputeResource", "network"}, {"ComputeResource", "resourcePool"}, {"ComputeResource", "summary"}, {"Datacenter", "datastore"}, {"Datacenter", "hostFolder"}, {"Datacenter", "network"}, {"Datacenter", "vmFolder"}, {"Folder", "childEntity"}, {"Folder", "childType"}, {"HostSystem", "capability"}, {"HostSystem", "config"}, {"HostSystem", "configManager"}, {"HostSystem", "datastore"}, {"HostSystem", "datastoreBrowser"}, {"HostSystem", "hardware"}, {"HostSystem", "network"}, {"HostSystem", "runtime"}, {"HostSystem", "summary"}, {"HostSystem", "systemResources"}, {"HostSystem", "vm"}, {"ResourcePool", "childConfiguration"}, {"ResourcePool", "config"}, {"ResourcePool", "owner"}, {"ResourcePool", "resourcePool"}, {"ResourcePool", "runtime"}, {"ResourcePool", "summary"}, {"ResourcePool", "vm"}, {"VirtualMachine", "capability"}, {"VirtualMachine", "config"}, {"VirtualMachine", "datastore"}, {"VirtualMachine", "environmentBrowser"}, {"VirtualMachine", "guest"}, {"VirtualMachine", "guestHeartbeatStatus"}, {"VirtualMachine", "layout"}, {"VirtualMachine", "network"}, {"VirtualMachine", "resourceConfig"}, {"VirtualMachine", "resourcePool"}, {"VirtualMachine", "runtime"}, {"VirtualMachine", "snapshot"}, {"VirtualMachine", "summary"}};
            ObjectContent[] ocary = this.getContentsRecursively(null, null, this.typeInfo, true);
            this.printContents(ocary);
        }
        catch (Exception e) {
            System.out.println("Main Exceptions Are Here");
            this.logException(e);
            this.logLine(" : Failed Getting Contents");
            throw e;
        }
        this.logLine(" : Successful Getting Contents");
    }

    private void printContents(ObjectContent[] ocary) {
        ObjectContent oc = null;
        ManagedObjectReference mor = null;
        DynamicProperty[] pcary = null;
        DynamicProperty pc = null;
        int pcount = 0;
        if (ocary != null) {
            for (int oci = 0; oci < ocary.length; ++oci) {
                oc = ocary[oci];
                mor = oc.getObj();
                pcary = oc.getPropSet();
                this.logLine("\n\n" + oci + " - Object Type : " + mor.getType());
                this.logLine("\tReference Value : " + mor.get_value());
                if (pcary == null) continue;
                for (int pci = 0; pci < pcary.length; ++pci) {
                    Serializable aoe;
                    ++pcount;
                    pc = pcary[pci];
                    this.logLine("\t\tProperty Name : " + pc.getName());
                    if (pc == null) continue;
                    this.logLine("\t\t\tProperty Value Class : " + pc.getVal().getClass().getName());
                    Object val = pc.getVal();
                    if (val instanceof ArrayOfAlarmState) {
                        aoe = (ArrayOfAlarmState)val;
                        this.printArray(((ArrayOfAlarmState)aoe).getAlarmState());
                        continue;
                    }
                    if (val instanceof ArrayOfCustomFieldValue) {
                        aoe = (ArrayOfCustomFieldValue)val;
                        this.printArray(((ArrayOfCustomFieldValue)aoe).getCustomFieldValue());
                        continue;
                    }
                    if (val instanceof ArrayOfEvent) {
                        aoe = (ArrayOfEvent)val;
                        this.printArray(((ArrayOfEvent)aoe).getEvent());
                        continue;
                    }
                    if (val instanceof ArrayOfInt) {
                        aoe = (ArrayOfInt)val;
                        this.printArray(((ArrayOfInt)aoe).get_int());
                        continue;
                    }
                    if (val instanceof ArrayOfManagedObjectReference) {
                        aoe = (ArrayOfManagedObjectReference)val;
                        this.printArray(((ArrayOfManagedObjectReference)aoe).getManagedObjectReference());
                        continue;
                    }
                    if (val instanceof ArrayOfPermission) {
                        aoe = (ArrayOfPermission)val;
                        this.printArray(((ArrayOfPermission)aoe).getPermission());
                        continue;
                    }
                    if (val instanceof ArrayOfResourceConfigSpec) {
                        aoe = (ArrayOfResourceConfigSpec)val;
                        this.printArray(((ArrayOfResourceConfigSpec)aoe).getResourceConfigSpec());
                        continue;
                    }
                    if (val instanceof ArrayOfString) {
                        aoe = (ArrayOfString)val;
                        this.printArray(((ArrayOfString)aoe).getString());
                        continue;
                    }
                    if (!val.getClass().isArray()) {
                        this.logLine("\t\t\tProperty Value : " + val);
                        continue;
                    }
                    Object[] ipcary = (Object[])pc.getVal();
                    this.logLine("\t\t\tVal : " + pc.getVal());
                    for (int ii = 0; ii < ipcary.length; ++ii) {
                        Object oval = ipcary[ii];
                        if (oval.getClass().getName().indexOf("ManagedObjectReference") >= 0) {
                            ManagedObjectReference imor = (ManagedObjectReference)oval;
                            this.logLine("\t\t\tInner Object Type : " + imor.getType());
                            this.logLine("\t\t\tInner Reference Value : " + imor.get_value());
                            continue;
                        }
                        this.logLine("\t\t\tInner Property Value : " + oval);
                    }
                }
            }
        }
        this.logLine("Done Printing Inventory");
        this.logLine("\n" + ocary.length + " top entries found, " + pcount + " 2nd level entries found");
    }

    public SelectionSpec[] buildFullTraversal() {
        TraversalSpec rpToRp = new TraversalSpec(null, null, null, "ResourcePool", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        rpToRp.setName("rpToRp");
        TraversalSpec rpToVm = new TraversalSpec(null, null, null, "ResourcePool", "vm", Boolean.FALSE, new SelectionSpec[0]);
        rpToVm.setName("rpToVm");
        TraversalSpec crToRp = new TraversalSpec(null, null, null, "ComputeResource", "resourcePool", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "rpToRp"), new SelectionSpec(null, null, "rpToVm")});
        crToRp.setName("crToRp");
        TraversalSpec crToH = new TraversalSpec(null, null, null, "ComputeResource", "host", Boolean.FALSE, new SelectionSpec[0]);
        crToH.setName("crToH");
        TraversalSpec dcToHf = new TraversalSpec(null, null, null, "Datacenter", "hostFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToHf.setName("dcToHf");
        TraversalSpec dcToVmf = new TraversalSpec(null, null, null, "Datacenter", "vmFolder", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        dcToVmf.setName("dcToVmf");
        TraversalSpec HToVm = new TraversalSpec(null, null, null, "HostSystem", "vm", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders")});
        HToVm.setName("HToVm");
        TraversalSpec visitFolders = new TraversalSpec(null, null, null, "Folder", "childEntity", Boolean.FALSE, new SelectionSpec[]{new SelectionSpec(null, null, "visitFolders"), new SelectionSpec(null, null, "dcToHf"), new SelectionSpec(null, null, "dcToVmf"), new SelectionSpec(null, null, "crToH"), new SelectionSpec(null, null, "crToRp"), new SelectionSpec(null, null, "HToVm"), new SelectionSpec(null, null, "rpToVm")});
        visitFolders.setName("visitFolders");
        return new SelectionSpec[]{visitFolders, dcToVmf, dcToHf, crToH, crToRp, rpToRp, HToVm, rpToVm};
    }

    public PropertySpec[] buildPropertySpecArray(String[][] typeinfo) {
        HashMap tInfo = new HashMap();
        for (int ti = 0; ti < typeinfo.length; ++ti) {
            HashSet<String> props = (HashSet<String>)tInfo.get(typeinfo[ti][0]);
            if (props == null) {
                props = new HashSet<String>();
                tInfo.put(typeinfo[ti][0], props);
            }
            boolean typeSkipped = false;
            for (int pi = 0; pi < typeinfo[ti].length; ++pi) {
                String prop = typeinfo[ti][pi];
                if (typeSkipped) {
                    props.add(prop);
                    continue;
                }
                typeSkipped = true;
            }
        }
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        for (String type : tInfo.keySet()) {
            PropertySpec pSpec = new PropertySpec();
            Set props = (Set)tInfo.get(type);
            pSpec.setType(type);
            pSpec.setAll(props.isEmpty() ? Boolean.TRUE : Boolean.FALSE);
            pSpec.setPathSet(new String[props.size()]);
            int index = 0;
            for (String prop : props) {
                pSpec.setPathSet(index++, prop);
            }
            pSpecs.add(pSpec);
        }
        return pSpecs.toArray(new PropertySpec[0]);
    }

    public void logLine(String strmsg) {
        System.out.println(strmsg);
    }

    private void printArray(int[] ipcary) {
        this.logLine("\t\t\tVal : " + ipcary);
        if (null != ipcary) {
            for (int ii = 0; ii < ipcary.length; ++ii) {
                Integer oval = ipcary[ii];
                if (oval.getClass().getName().indexOf("ManagedObjectReference") >= 0) {
                    ManagedObjectReference imor = (ManagedObjectReference)((Object)oval);
                    this.logLine("\t\t\tInner Object Type : " + imor.getType());
                    this.logLine("\t\t\tInner Reference Value : " + imor.get_value());
                    continue;
                }
                this.logLine("\t\t\tInner Property Value : " + oval);
            }
        }
    }

    private void printArray(Object[] ipcary) {
        this.logLine("\t\t\tVal : " + ipcary);
        if (null != ipcary) {
            for (int ii = 0; ii < ipcary.length; ++ii) {
                Object oval = ipcary[ii];
                this.logLine("\t\t\t" + ii + " : ");
                if (oval.getClass().getName().indexOf("ManagedObjectReference") >= 0) {
                    ManagedObjectReference imor = (ManagedObjectReference)oval;
                    this.logLine("\t\t\t\tInner Object Type : " + imor.getType());
                    this.logLine("\t\t\t\tInner Reference Value : " + imor.get_value());
                    continue;
                }
                if (oval instanceof Permission) {
                    Permission p = (Permission)oval;
                    this.logLine("\t\t\t\tPermission : principal=" + p.getPrincipal() + ";roleId=" + p.getRoleId());
                    continue;
                }
                this.logLine("\t\t\t\tInner Property Class : " + oval.getClass().getName());
                this.logLine("\t\t\t\tInner Property Value : " + oval);
            }
        }
    }

    public void logException(Exception e) {
        if (e instanceof MethodFault) {
            MethodFault mf = (MethodFault)e;
            this.logFault(mf);
        } else {
            this.logLine("Caught Exception :  Exception : " + e.getClass().getName() + " Message : " + e.getMessage() + " StackTrace : ");
            e.printStackTrace();
        }
    }

    public void logFault(MethodFault mf) {
        this.logLine("Caught Fault - \n Type : " + mf.getClass().getName() + "\n Actor : " + mf.getFaultActor() + "\n Code : " + mf.getFaultNode() + "\n Reason : " + mf.getFaultReason() + "\n Fault String : " + mf.getFaultString());
    }

    public static class Version {
        private String m_name;
        private String m_fullName;
        private String m_vendor;
        private String m_version;
        private String m_build;
        private String m_localeVersion;
        private String m_localeBuild;
        private String m_osType;
        private String m_productLineId;
        private String m_apiType;
        private String m_apiVersion;
        private static final String VERSION_THREE_FIVE = "3.5.0";
        private static final String PRODUCT_LINE_ESX_EMBEDDED = "embeddedEsx";

        public boolean isVersionThreeFive() {
            return this.getVersion().equals(VERSION_THREE_FIVE);
        }

        public boolean isProductLineEmbedded() {
            return null != this.getProductLineId() && this.getProductLineId().equals(PRODUCT_LINE_ESX_EMBEDDED);
        }

        public boolean equals(Object object) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("AboutInfo: ");
            buf.append("ApiType=");
            buf.append(this.getApiType());
            buf.append(";ApiVersion=");
            buf.append(this.getApiVersion());
            buf.append(";Build=");
            buf.append(this.getBuild());
            buf.append(";FullName=");
            buf.append(this.getFullName());
            buf.append(";LocaleBuild=");
            buf.append(this.getLocaleBuild());
            buf.append(";LocaleVersion=");
            buf.append(this.getLocaleVersion());
            buf.append(";Name=");
            buf.append(this.getName());
            buf.append(";OsType=");
            buf.append(this.getOsType());
            buf.append(";Vendor=");
            buf.append(this.getVendor());
            buf.append(";Version=");
            buf.append(this.getVersion());
            return buf.toString();
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getFullName() {
            return this.m_fullName;
        }

        public void setFullName(String fullName) {
            this.m_fullName = fullName;
        }

        public String getVendor() {
            return this.m_vendor;
        }

        public void setVendor(String vendor) {
            this.m_vendor = vendor;
        }

        public String getVersion() {
            return this.m_version;
        }

        public void setVersion(String version) {
            this.m_version = version;
        }

        public String getBuild() {
            return this.m_build;
        }

        public void setBuild(String build) {
            this.m_build = build;
        }

        public String getLocaleVersion() {
            return this.m_localeVersion;
        }

        public void setLocaleVersion(String localeVersion) {
            this.m_localeVersion = localeVersion;
        }

        public String getLocaleBuild() {
            return this.m_localeBuild;
        }

        public void setLocaleBuild(String localeBuild) {
            this.m_localeBuild = localeBuild;
        }

        public String getOsType() {
            return this.m_osType;
        }

        public void setOsType(String osType) {
            this.m_osType = osType;
        }

        public String getProductLineId() {
            return this.m_productLineId;
        }

        public void setProductLineId(String productLineId) {
            this.m_productLineId = productLineId;
        }

        public String getApiType() {
            return this.m_apiType;
        }

        public void setApiType(String apiType) {
            this.m_apiType = apiType;
        }

        public String getApiVersion() {
            return this.m_apiVersion;
        }

        public void setApiVersion(String apiVersion) {
            this.m_apiVersion = apiVersion;
        }
    }
}

