/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.xml;

import com.tripwire.common.util.xml.AbstractXmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.ValidationException;
import com.tripwire.space.core.conditional.XmlExtractor;
import com.tripwire.space.core.conditional.xml.XmlExtractorXmlConstants;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;

public class XmlExtractorXmlElementParser
extends AbstractXmlElementParser
implements XmlExtractorXmlConstants {
    public XmlExtractorXmlElementParser() {
        super(XML_EXTRACTOR_ELEMENT, XmlExtractor.class);
    }

    protected Object createInstanceAndReadAttributes(XmlInputContext in) throws XmlException {
        try {
            String xPath = in.getStringAttribute(XPATH_ATTRIBUTE);
            QName returnType = this.getReturnType(in.getStringAttribute(RETURN_TYPE_ATTRIBUTE));
            XmlExtractor xmlExtractor = new XmlExtractor(xPath);
            xmlExtractor.setReturnType(returnType);
            return xmlExtractor;
        }
        catch (ValidationException vex) {
            throw XmlException.asXmlException(vex);
        }
    }

    private QName getReturnType(String type) {
        if (type.equals("Boolean")) {
            return XPathConstants.BOOLEAN;
        }
        if (type.equals("NodeSet")) {
            return XPathConstants.NODESET;
        }
        if (type.equals("Number")) {
            return XPathConstants.NUMBER;
        }
        if (type.equals("Node")) {
            return XPathConstants.NODE;
        }
        return XPathConstants.STRING;
    }
}

