/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.operator;

import com.tripwire.common.util.Regex;
import com.tripwire.space.core.conditional.operator.BinaryOperator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ContainOperator
extends BinaryOperator {
    ContainOperator() {
    }

    public int getId() {
        return 12;
    }

    public boolean evaluate(Object operand, Object pattern) {
        if (operand == null || pattern == null || !(operand instanceof String) || !(pattern instanceof String)) {
            return false;
        }
        String operandStr = (String)operand;
        String patternStr = (String)pattern;
        if (patternStr.length() == 0) {
            return true;
        }
        if (operandStr.length() == 0) {
            return false;
        }
        try {
            Pattern regex = Regex.wildcardToPattern(patternStr, 2);
            return regex.matcher(operandStr).find();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

