/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.Objects;
import com.tripwire.common.util.PropertyStream;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.CachedOperandExtractor;
import com.tripwire.space.core.conditional.ConditionTrace;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ConditionalVisitor;
import com.tripwire.space.core.conditional.OperandExtractor;
import com.tripwire.space.core.conditional.operator.Operator;
import com.tripwire.space.core.conditional.operator.OperatorRepository;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class ConditionalPredicate
implements Conditional {
    private static final long serialVersionUID = 1L;
    private transient boolean m_negate = false;
    private transient Operator m_operator;
    private transient OperandExtractor m_lhsExtractor;
    private transient Object m_rhs;

    public ConditionalPredicate(int operator, OperandExtractor lhsExtractor) {
        this.m_operator = OperatorRepository.get(operator);
        assert (this.m_operator != null);
        assert (this.m_operator.isUnary());
        assert (lhsExtractor != null);
        this.m_lhsExtractor = lhsExtractor;
        this.m_rhs = null;
    }

    public ConditionalPredicate(int operator, OperandExtractor lhsExtractor, Object rhs) {
        this.m_operator = OperatorRepository.get(operator);
        assert (this.m_operator != null);
        assert (!this.m_operator.isUnary());
        assert (lhsExtractor != null);
        this.m_lhsExtractor = lhsExtractor;
        this.m_rhs = rhs;
    }

    public Operator getOperator() {
        return this.m_operator;
    }

    public OperandExtractor getLhsOperandExtractor() {
        return this.m_lhsExtractor;
    }

    public Object getRhsOperand() {
        return this.m_rhs;
    }

    public boolean isNegated() {
        return this.m_negate;
    }

    public void negate(boolean b) {
        this.m_negate = b;
    }

    public boolean accept(ConditionalVisitor visitor) throws SpaceException {
        return visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Object source) throws Exception {
        PropertyStream trace = ConditionTrace.getPropertyStream();
        try {
            if (trace != null) {
                trace.begin(this.m_operator.getClass().getName());
                trace.property("Negate", this.m_negate);
            }
            boolean eval = false;
            try {
                eval = this.m_lhsExtractor.evaluate(this.m_operator, source, this.m_rhs);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            boolean bl = this.m_negate ? !eval : eval;
            return bl;
        }
        finally {
            ConditionTrace.end();
        }
    }

    public void reset() {
        if (this.m_lhsExtractor instanceof CachedOperandExtractor) {
            ((CachedOperandExtractor)this.m_lhsExtractor).reset();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionalPredicate that = (ConditionalPredicate)obj;
        return this.m_negate == that.m_negate && this.m_operator.getId() == that.m_operator.getId() && this.m_lhsExtractor.equals(that.m_lhsExtractor) && this.rhsEquals(that.m_rhs);
    }

    private boolean rhsEquals(Object rhs) {
        int opId = this.m_operator.getId();
        return opId == 5 || opId == 11 ? Arrays.equals((Object[])this.m_rhs, (Object[])rhs) : Objects.equals(this.m_rhs, rhs);
    }

    public int hashCode() {
        int hash = this.m_operator.getId() ^ this.m_lhsExtractor.hashCode();
        if (this.m_rhs != null) {
            hash ^= this.m_rhs.hashCode();
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.m_negate);
        out.writeInt(this.m_operator.getId());
        out.writeObject(this.m_lhsExtractor);
        if (!this.m_operator.isUnary()) {
            out.writeObject(this.m_rhs);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_negate = in.readBoolean();
        this.m_operator = OperatorRepository.get(in.readInt());
        this.m_lhsExtractor = (OperandExtractor)in.readObject();
        this.m_rhs = this.m_operator.isUnary() ? null : in.readObject();
    }
}

