/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.view;

import com.tripwire.honeybee.ui.controller.HoneybeeControllerImpl;
import com.tripwire.honeybee.ui.model.HoneybeeModel;
import com.tripwire.honeybee.ui.model.eula.EulaModel;
import com.tripwire.honeybee.ui.model.testrunner.TestRunnerDialogModel;
import com.tripwire.honeybee.ui.view.UnknownViewException;
import com.tripwire.honeybee.ui.view.ViewPresenter;
import com.tripwire.honeybee.ui.view.eula.EulaWindow;
import com.tripwire.honeybee.ui.view.main.MainWindow;

public class SwingViewPresenter
implements ViewPresenter {
    public void presentView(String viewName, HoneybeeModel model) throws UnknownViewException {
        if (viewName.equals("EulaView")) {
            this.presentEulaView((EulaModel)model);
        } else if (viewName.equals("TestRunnerView")) {
            this.presentTestRunnerView((TestRunnerDialogModel)model);
        } else {
            throw new UnknownViewException(viewName);
        }
    }

    protected void presentEulaView(EulaModel model) {
        EulaWindow eulaWindow = new EulaWindow(HoneybeeControllerImpl.getInstance(), model);
        eulaWindow.init();
        eulaWindow.Open();
    }

    protected void presentTestRunnerView(TestRunnerDialogModel model) {
        MainWindow window = new MainWindow(HoneybeeControllerImpl.getInstance(), model.getComplianceAssessmentModel(), model.getMarketingCollateralModel());
        window.init();
        window.Open();
    }
}

