/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.marketing;

import com.tripwire.honeybee.ui.model.marketing.AbstractCollateralModel;
import com.tripwire.honeybee.ui.model.marketing.LinkedImage;
import com.tripwire.honeybee.ui.model.marketing.MarketingCollateralModel;
import com.tripwire.honeybee.ui.model.marketing.TopBannerModel;
import java.awt.Image;
import java.util.MissingResourceException;

public class TopBannerModelImpl
extends AbstractCollateralModel
implements TopBannerModel {
    protected LinkedImage[] bannerImages = new LinkedImage[MarketingCollateralModel.ALL_PHASES.length];
    protected String m_baseRemediationUrl = null;
    protected String m_remediationMessage = null;

    protected void loadAssets(int phase) throws Exception {
        String link;
        this.m_baseRemediationUrl = this.getAssetRetriever().getString("tw.remediation.url");
        this.m_remediationMessage = this.getAssetRetriever().getString("tw.remediation.message");
        String imageLocation = this.getAssetRetriever().getString(this.getPhasedResource("topBanner.image", phase));
        try {
            link = this.getAssetRetriever().getString(this.getPhasedResource("topBanner.link", phase));
        }
        catch (MissingResourceException e) {
            link = null;
        }
        if (imageLocation == null || imageLocation.length() == 0) {
            this.setValid(false);
        }
        this.bannerImages[phase] = new LinkedImage(this.getAssetRetriever().loadImage(imageLocation), link);
    }

    public LinkedImage getBannerImage(int phase) {
        return this.bannerImages[phase];
    }

    public Image getWindowIcon(int phase) {
        try {
            String imageLocation = this.getAssetRetriever().getString("windowIcon.image");
            return this.getAssetRetriever().loadImage(imageLocation);
        }
        catch (Exception e) {
            this.setValid(false);
            return null;
        }
    }

    public String getRemediationUrl(String id, String policyFile) {
        if (this.isSupplyingRemediationUrls()) {
            String url = this.m_baseRemediationUrl.replace("{0}", id);
            if (policyFile != null) {
                url = url.replace("{1}", policyFile);
            }
            return url;
        }
        return null;
    }

    public String getRemediationMessage() {
        if (this.m_remediationMessage != null && this.m_remediationMessage.length() > 0) {
            return this.m_remediationMessage;
        }
        return null;
    }

    public boolean isSupplyingRemediationUrls() {
        return this.m_baseRemediationUrl != null && this.m_baseRemediationUrl.length() > 0;
    }

    public String getMoreInfoText() {
        try {
            return this.getAssetRetriever().getString("tw.moreInformation.text");
        }
        catch (Exception e) {
            this.setValid(false);
            return null;
        }
    }
}

