/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.controller;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.honeybee.ui.controller.HoneybeeController;
import com.tripwire.honeybee.ui.controller.HoneybeeRequest;
import com.tripwire.honeybee.ui.controller.RequestInfo;
import com.tripwire.honeybee.ui.controller.UnknownRequestException;
import com.tripwire.honeybee.ui.controller.requests.RespondToEulaRequest;
import com.tripwire.honeybee.ui.model.HoneybeeModel;
import com.tripwire.honeybee.ui.model.ModelFactory;
import com.tripwire.honeybee.ui.model.UnknownModelException;
import com.tripwire.honeybee.ui.view.UnknownViewException;
import com.tripwire.honeybee.ui.view.ViewPresenter;

public class HoneybeeControllerImpl
implements HoneybeeController {
    private static HoneybeeControllerImpl sm_instance = new HoneybeeControllerImpl();
    protected ModelFactory m_modelFactory;
    protected ViewPresenter m_viewPresenter;
    protected boolean m_isStillRunning = true;

    public static HoneybeeControllerImpl getInstance() {
        return sm_instance;
    }

    private HoneybeeControllerImpl() {
    }

    protected ViewPresenter getViewPresenter() {
        return this.m_viewPresenter;
    }

    public void setViewPresenter(ViewPresenter viewPresenter) {
        this.m_viewPresenter = viewPresenter;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.m_modelFactory = modelFactory;
    }

    protected ModelFactory getModelFactory() {
        return this.m_modelFactory;
    }

    public void handleRequest(HoneybeeRequest request) throws UnknownRequestException, UnknownModelException, UnknownViewException {
        if (request.getAction().equals("startApp")) {
            HoneybeeModel model = this.getModelFactory().createModel("ResourceBasedEulaModel", (RequestInfo)request.getAdditionalInformation());
            this.getViewPresenter().presentView("EulaView", model);
        } else if (request.getAction().equals("respondToEula")) {
            RespondToEulaRequest eulaRequest = (RespondToEulaRequest)request;
            if (((RespondToEulaRequest.EulaRequestInfo)eulaRequest.getAdditionalInformation()).isAccepted()) {
                HoneybeeModel model = this.getModelFactory().createModel("TestRunnerDialogModel", (RequestInfo)request.getAdditionalInformation());
                this.getViewPresenter().presentView("TestRunnerView", model);
            } else {
                this.shutdown();
            }
        } else if (request.getAction().equals("CloseTestDialog")) {
            this.shutdown();
        } else {
            throw new UnknownRequestException(request.getAction());
        }
    }

    public boolean isStillRunning() {
        return this.m_isStillRunning;
    }

    public void shutdown() {
        this.m_isStillRunning = false;
    }

    static {
        ResourceManager rm = ResourceManager.getInstance();
        ClassLoader myLoader = HoneybeeControllerImpl.class.getClassLoader();
        rm.addStandardResources("com.tripwire.honeybee.ui", myLoader);
        rm.addStandardResources("com.tripwire.honeybee.ui.view.eula", myLoader);
        rm.addStandardResources("com.tripwire.honeybee.ui.view.main", myLoader);
    }
}

