/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.honeybee.ui.controller.HoneybeeControllerImpl;
import com.tripwire.honeybee.ui.controller.requests.StartApplicationRequest;
import com.tripwire.honeybee.ui.model.testrunner.HoneybeeModelFactory;
import com.tripwire.honeybee.ui.view.SwingViewPresenter;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class HoneybeeUIApplication {
    protected static String sm_distributor = null;

    public static void main(String[] args) throws Exception {
        String remoteUrl = "http://www.tripwire.com/config_check";
        if (args.length > 0 && args.length >= 2 && args[0].equals("-r")) {
            remoteUrl = args[1];
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        if (d.width < 1024 || d.height < 768) {
            System.err.println(ResourceManager.getInstance().getString("tw.honeybee.resolution.too.low", new Object[]{1024, 768}));
            System.exit(0);
        }
        HoneybeeControllerImpl controller = HoneybeeControllerImpl.getInstance();
        controller.setModelFactory(new HoneybeeModelFactory(remoteUrl));
        controller.setViewPresenter(new SwingViewPresenter());
        controller.handleRequest(new StartApplicationRequest());
        while (controller.isStillRunning()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
    }

    public static String getVersion() {
        return ResourceManager.getInstance().getString("application.version");
    }

    public static String getPolicies() {
        return ResourceManager.getInstance().getString("supported.policies");
    }

    public static String getLocale() {
        return Locale.getDefault().toString();
    }

    public static String getDistributor() {
        if (sm_distributor == null) {
            String TRIPWIRE = "tripwire";
            try {
                InputStream in = HoneybeeUIApplication.class.getClassLoader().getResourceAsStream("com/tripwire/honeybee/ui/distributor.properties");
                if (in != null) {
                    Properties distributorProps = new Properties();
                    distributorProps.load(in);
                    sm_distributor = distributorProps.getProperty("tw.honeybee.distributor", "tripwire");
                }
            }
            catch (Exception e) {
                sm_distributor = "tripwire";
            }
        }
        return sm_distributor;
    }

    static {
        ResourceManager.getInstance().addStandardResources(HoneybeeUIApplication.class);
    }
}

