/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.xml;

import com.tripwire.common.collections.CollectionTools;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.xml.XmlAttributeName;
import com.tripwire.common.util.xml.XmlAttributeNotFoundException;
import com.tripwire.common.util.xml.XmlDateParsingException;
import com.tripwire.common.util.xml.XmlElementName;
import com.tripwire.common.util.xml.XmlElementParser;
import com.tripwire.common.util.xml.XmlElementProxy;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlIllegalAttributeValueException;
import com.tripwire.common.util.xml.XmlIllegalBooleanValueException;
import com.tripwire.common.util.xml.XmlIllegalIntegerValueException;
import com.tripwire.common.util.xml.XmlInputFormat;
import com.tripwire.common.util.xml.XmlLineOrientedException;
import com.tripwire.common.util.xml.XmlMissingTagException;
import com.tripwire.common.util.xml.XmlName;
import com.tripwire.common.util.xml.XmlNoParserForElementException;
import com.tripwire.common.util.xml.XmlOutputContext;
import com.tripwire.common.util.xml.XmlParserException;
import com.tripwire.common.util.xml.XmlReferenceResolver;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlInputContext {
    protected static final DateFormat XML_DATE_FORMAT = XmlOutputContext.XML_DATE_FORMAT;
    private static final XmlAttributeName XML_FORMAT_ATTRIBUTE = new XmlAttributeName("format");
    private final XmlPullParser m_parser;
    private final XmlInputFormat m_format;
    protected final Map m_identifiers = CollectionTools.createMap();
    private final List m_resolvers = new ArrayList();

    public XmlInputContext(Reader input, XmlInputFormat format) throws XmlException, IOException {
        assert (input != null);
        assert (format != null);
        this.m_format = format;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.m_parser = factory.newPullParser();
            this.m_parser.setInput(input);
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
        this.nextToken();
    }

    public boolean attributeExists(XmlAttributeName attribute) {
        assert (attribute != null);
        return this.m_parser.getAttributeValue(attribute.getNamespace(), attribute.getName()) != null;
    }

    public boolean detectElementStart() throws XmlException {
        return this.eventTypeIs(2);
    }

    public int getLineNumber() {
        return this.m_parser.getLineNumber();
    }

    public boolean isParsing() {
        int eventType;
        try {
            eventType = this.m_parser.getEventType();
        }
        catch (XmlPullParserException e) {
            return false;
        }
        return eventType != 0 && eventType != 1;
    }

    public boolean detectElementStart(XmlElementName element) throws XmlException {
        assert (element != null);
        return this.detectElementStart() && this.matchesElementName(element);
    }

    public void assertElementStart(XmlElementName element) throws XmlException {
        if (!this.detectElementStart(element)) {
            throw new XmlException(ResourceManager.getInstance().getSafeString("error.xml.expectedStartElement", new Object[]{element}));
        }
    }

    public Object findObjectWithIdentifier(String id) throws XmlException {
        assert (id != null);
        return this.m_identifiers.get(id);
    }

    public boolean getBooleanAttribute(XmlAttributeName attribute) throws XmlException {
        assert (attribute != null);
        assert (this.detectElementStart());
        return this.convertStringToBooleanValue(this.getStringAttribute(attribute), attribute);
    }

    public int getIntegerAttribute(XmlAttributeName attribute, int min, int max) throws XmlException {
        assert (attribute != null);
        assert (this.detectElementStart());
        return this.convertStringToIntegerValue(this.getStringAttribute(attribute), attribute, min, max);
    }

    public long getLongAttribute(XmlAttributeName attribute) throws XmlException {
        return this.getLongAttribute(attribute, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public long getLongAttribute(XmlAttributeName attribute, long min, long max) throws XmlException {
        assert (attribute != null);
        assert (this.detectElementStart());
        return this.convertStringToLongValue(this.getStringAttribute(attribute), attribute, min, max);
    }

    public float getFloatAttribute(XmlAttributeName attribute) throws XmlException {
        return this.getFloatAttribute(attribute, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public float getFloatAttribute(XmlAttributeName attribute, float min, float max) throws XmlException {
        assert (attribute != null);
        assert (this.detectElementStart());
        return this.convertStringToFloatValue(this.getStringAttribute(attribute), attribute, min, max);
    }

    public String getStringAttribute(XmlAttributeName attribute) throws XmlException {
        return this.getStringAttribute(attribute, true);
    }

    public String getStringAttribute(XmlAttributeName attribute, boolean required) throws XmlException {
        assert (attribute != null);
        assert (this.detectElementStart());
        String value = this.m_parser.getAttributeValue(attribute.getNamespace(), attribute.getName());
        if (value == null && required) {
            throw new XmlAttributeNotFoundException(attribute, this.m_parser.getLineNumber());
        }
        return value;
    }

    public void identifyObject(String id, Object obj) throws XmlException {
        assert (id != null);
        assert (obj != null);
        this.m_identifiers.put(id, obj);
    }

    public Object maybeParseObjectElement() throws XmlException, IOException {
        return this.maybeParseObjectElement(Object.class);
    }

    protected XmlElementParser getParser(XmlElementName name) throws XmlNoParserForElementException {
        XmlElementName unqualified = new XmlElementName(name.getName());
        XmlElementParser parser = this.m_format.getParserForElement(unqualified);
        if (parser == null) {
            throw new XmlNoParserForElementException(name);
        }
        return parser;
    }

    public Object maybeParseObjectElement(Class expectedClass) throws XmlException, IOException {
        assert (expectedClass != null);
        if (!this.detectElementStart()) {
            return null;
        }
        XmlElementParser parser = this.getParser(this.getNameForNextElement());
        Class targetClass = parser.getTargetClass();
        if (!expectedClass.isAssignableFrom(targetClass)) {
            System.err.println("Unexpected class type in maybeParseObjectElement at line " + this.m_parser.getLineNumber() + "; expected " + expectedClass.toString() + " found " + targetClass.toString());
            this.skipNextElement();
            return null;
        }
        return parser.read(this);
    }

    public XmlElementName getNameForNextElement() throws XmlException {
        assert (this.detectElementStart());
        String nameSpace = this.m_parser.getNamespace();
        String name = this.m_parser.getName();
        return new XmlElementName(nameSpace, name);
    }

    public void skipNextElement() throws XmlException, IOException {
        assert (this.detectElementStart());
        if (!this.detectElementStart()) {
            throw new XmlLineOrientedException("skipNextElement called when not at element start", this.m_parser.getLineNumber());
        }
        int level = 0;
        do {
            if (this.eventTypeIs(2)) {
                ++level;
            } else if (this.eventTypeIs(3)) {
                --level;
            }
            this.nextToken();
        } while (level > 0);
    }

    public boolean parseBooleanElement(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        return this.convertStringToBooleanValue(this.parseStringElement(element), element);
    }

    public int parseIntegerElement(XmlElementName element) throws XmlException, IOException {
        return this.parseIntegerElement(element, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int parseIntegerElement(XmlElementName element, int min, int max) throws XmlException, IOException {
        assert (element != null);
        assert (max >= min);
        return this.convertStringToIntegerValue(this.parseStringElement(element), element, min, max);
    }

    public long parseLongElement(XmlElementName element) throws XmlException, IOException {
        return this.parseLongElement(element, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public long parseLongElement(XmlElementName element, long min, long max) throws XmlException, IOException {
        assert (element != null);
        assert (max >= min);
        return this.convertStringToLongValue(this.parseStringElement(element), element, min, max);
    }

    public String parseStringElement(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.detectElementStart(element)) {
            throw new XmlMissingTagException(this.m_parser.getLineNumber(), element, true);
        }
        try {
            this.m_parser.next();
            String text = "";
            if (this.eventTypeIs(4)) {
                text = this.m_parser.getText();
                this.m_parser.next();
            }
            this.skipElementEnd(element);
            return text;
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    public String parseStringContentBody() throws IOException, XmlException {
        try {
            if (this.detectElementStart()) {
                this.m_parser.next();
            }
            String text = "";
            if (this.eventTypeIs(4)) {
                text = this.m_parser.getText();
                this.m_parser.next();
            }
            return text;
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    public Date parseDateElement(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.detectElementStart(element)) {
            throw new XmlMissingTagException(this.m_parser.getLineNumber(), element, true);
        }
        try {
            DateFormat datefmt = XML_DATE_FORMAT;
            String fmtstr = this.getStringAttribute(XML_FORMAT_ATTRIBUTE, false);
            if (fmtstr != null) {
                datefmt = new SimpleDateFormat(fmtstr);
            }
            this.m_parser.next();
            String text = "";
            if (this.eventTypeIs(4)) {
                text = this.m_parser.getText();
                this.m_parser.next();
            }
            this.skipElementEnd(element);
            return datefmt.parse(text);
        }
        catch (ParseException ex) {
            throw new XmlDateParsingException(this.getLineNumber(), ex);
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    boolean maybeSkipElementStart(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.eventTypeIs(2) || !this.matchesElementName(element)) {
            return false;
        }
        this.nextToken();
        return true;
    }

    boolean maybeSkipElementEnd(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.eventTypeIs(3) || !this.matchesElementName(element)) {
            return false;
        }
        this.nextToken();
        return true;
    }

    public void skipElementStart(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.maybeSkipElementStart(element)) {
            throw new XmlMissingTagException(this.m_parser.getLineNumber(), element, true);
        }
    }

    public void skipElementEnd(XmlElementName element) throws XmlException, IOException {
        assert (element != null);
        if (!this.maybeSkipElementEnd(element)) {
            throw new XmlMissingTagException(this.m_parser.getLineNumber(), element, false);
        }
    }

    public void resolveReferenceLater(XmlReferenceResolver resolver) {
        assert (resolver != null);
        assert (!this.m_resolvers.contains(resolver));
        this.m_resolvers.add(resolver);
    }

    public void resolveReferences() throws XmlException {
        try {
            for (Object obj : this.m_identifiers.values()) {
                if (!(obj instanceof XmlElementProxy)) continue;
                ((XmlElementProxy)obj).resolveReferences(this);
            }
        }
        catch (Exception ex) {
            throw XmlException.asXmlException(ex);
        }
        int limit = this.m_resolvers.size();
        for (int i = limit - 1; i >= 0; --i) {
            XmlReferenceResolver resolver = (XmlReferenceResolver)this.m_resolvers.get(i);
            this.m_resolvers.remove(resolver);
            resolver.resolveReference(this);
        }
        assert (this.m_resolvers.isEmpty());
    }

    public void realizeAll() throws XmlException {
        try {
            for (Object obj : this.m_identifiers.values()) {
                if (!(obj instanceof XmlElementProxy)) continue;
                ((XmlElementProxy)obj).realize(this);
            }
        }
        catch (Exception ex) {
            throw XmlException.asXmlException(ex);
        }
    }

    private boolean eventTypeIs(int type) throws XmlException {
        assert (type == 0 || type == 2 || type == 4 || type == 3 || type == 1);
        try {
            return this.m_parser.getEventType() == type;
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    private void nextToken() throws XmlException, IOException {
        try {
            this.m_parser.next();
            if (this.eventTypeIs(4) && this.m_parser.isWhitespace()) {
                this.m_parser.next();
            }
        }
        catch (XmlPullParserException ex) {
            throw new XmlParserException(ex);
        }
    }

    private boolean matchesElementName(XmlElementName element) {
        assert (element != null);
        return this.m_parser.getName().equals(element.getName());
    }

    public boolean convertStringToBooleanValue(String value, XmlName name) throws XmlException {
        assert (value != null);
        assert (name != null);
        if ((value = value.trim()).equals("true") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("0")) {
            return false;
        }
        throw new XmlIllegalBooleanValueException(this.getLineNumber(), name);
    }

    public int convertStringToIntegerValue(String value, XmlName name, int min, int max) throws XmlException {
        assert (value != null);
        assert (name != null);
        assert (max >= min);
        return (int)this.convertStringToLongValue(value, name, min, max);
    }

    private long convertStringToLongValue(String value, XmlName name, long min, long max) throws XmlException {
        assert (value != null);
        assert (name != null);
        assert (max >= min);
        try {
            long result = Long.parseLong(value.trim());
            if (result >= min && result <= max) {
                return result;
            }
            throw new XmlIllegalIntegerValueException(this.getLineNumber(), name, min, max);
        }
        catch (NumberFormatException ex) {
            throw new XmlIllegalIntegerValueException(this.getLineNumber(), name, min, max);
        }
    }

    private float convertStringToFloatValue(String value, XmlName name, float min, float max) throws XmlException {
        assert (value != null);
        assert (name != null);
        assert (max >= min);
        try {
            float result = Float.parseFloat(value.trim());
            if (result >= min && result <= max) {
                return result;
            }
            throw new XmlIllegalAttributeValueException(this.getLineNumber(), name, value);
        }
        catch (NumberFormatException ex) {
            throw new XmlIllegalAttributeValueException(this.getLineNumber(), name, value);
        }
    }
}

