/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.xml;

import com.tripwire.common.collections.CollectionTools;
import com.tripwire.common.util.xml.XmlFilter;
import com.tripwire.common.util.xml.XmlOutputContext;
import java.util.Map;
import java.util.Set;

public class XmlFilterManager {
    protected Map m_classToFilterMap = CollectionTools.createMap();
    protected Set m_implicitFilters = CollectionTools.createSet();

    public void addFilter(Class clazz, XmlFilter f) {
        this.clearImplicitFilters();
        this.m_classToFilterMap.put(clazz, f);
    }

    public XmlFilter getFilter(Class theClass) {
        XmlFilter filter = XmlOutputContext.ACCEPT_ALL_FILTER;
        if (theClass != null && !this.m_classToFilterMap.isEmpty() && (filter = (XmlFilter)this.m_classToFilterMap.get(theClass)) == null) {
            Class currentClass = theClass;
            while (filter == null && (currentClass = currentClass.getSuperclass()) != null) {
                filter = (XmlFilter)this.m_classToFilterMap.get(currentClass);
            }
            if (filter == null) {
                filter = XmlOutputContext.ACCEPT_ALL_FILTER;
            }
            this.m_classToFilterMap.put(theClass, filter);
            this.m_implicitFilters.add(theClass);
        }
        return filter;
    }

    protected void clearImplicitFilters() {
        if (!this.m_implicitFilters.isEmpty()) {
            for (Class clazz : this.m_implicitFilters) {
                this.m_classToFilterMap.remove(clazz);
            }
            this.m_implicitFilters.clear();
        }
    }

    public void reset() {
        this.m_classToFilterMap = CollectionTools.createMap();
        this.m_implicitFilters = CollectionTools.createSet();
    }
}

