/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.xml;

import com.tripwire.common.util.xml.XmlConstants;
import com.tripwire.common.util.xml.XmlDuplicateIdException;
import com.tripwire.common.util.xml.XmlElementName;
import com.tripwire.common.util.xml.XmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import java.io.IOException;

public abstract class AbstractXmlElementParser
implements XmlElementParser,
XmlConstants {
    protected final XmlElementName m_element;
    private final Class m_targetClass;

    protected AbstractXmlElementParser(XmlElementName element, Class targetClass) {
        assert (element != null);
        assert (targetClass != null);
        this.m_element = element;
        this.m_targetClass = targetClass;
    }

    public Object read(XmlInputContext in) throws XmlException, IOException {
        assert (in != null);
        assert (in.detectElementStart(this.m_element));
        String identity = this.getIdentityAttribute(in);
        Object object = this.createInstanceAndReadAttributes(in);
        in.skipElementStart(this.m_element);
        this.readBody(in, object);
        in.skipElementEnd(this.m_element);
        object = this.finishObject(in, object);
        this.identifyObject(identity, object, in);
        return object;
    }

    protected void identifyObject(String identity, Object object, XmlInputContext in) throws XmlException {
        if (identity != null) {
            in.identifyObject(identity, object);
        }
    }

    public final XmlElementName getXmlElement() {
        return this.m_element;
    }

    public final Class getTargetClass() {
        return this.m_targetClass;
    }

    protected void readAttributes(XmlInputContext in, Object obj) throws XmlException {
    }

    protected Object createInstance(XmlInputContext in) throws XmlException {
        try {
            return this.m_targetClass.newInstance();
        }
        catch (Exception e) {
            throw new XmlException(this.m_targetClass.getName() + ':' + e.getMessage(), e);
        }
    }

    protected Object createInstanceAndReadAttributes(XmlInputContext in) throws XmlException {
        assert (in != null);
        Object obj = this.createInstance(in);
        this.readAttributes(in, obj);
        return obj;
    }

    protected final String getIdentityAttribute(XmlInputContext in) throws XmlException {
        assert (in != null);
        if (!in.attributeExists(ID_ATTRIBUTE)) {
            return null;
        }
        String id = in.getStringAttribute(ID_ATTRIBUTE);
        if (in.findObjectWithIdentifier(id) != null) {
            throw new XmlDuplicateIdException(in.getLineNumber(), id);
        }
        return id;
    }

    protected Object finishObject(XmlInputContext in, Object obj) throws XmlException {
        assert (in != null);
        assert (obj != null);
        return obj;
    }

    protected void readBody(XmlInputContext in, Object obj) throws XmlException, IOException {
        assert (in != null);
        assert (obj != null);
    }

    protected String parseDescription(XmlInputContext in) throws XmlException, IOException {
        return in.detectElementStart(DESCRIPTION_ELEMENT) ? in.parseStringElement(DESCRIPTION_ELEMENT) : null;
    }
}

