/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.system;

import com.tripwire.common.util.system.AixOperatingSystem;
import com.tripwire.common.util.system.HpuxOperatingSystem;
import com.tripwire.common.util.system.Ia32SystemArchitecture;
import com.tripwire.common.util.system.Ia64SystemArchitecture;
import com.tripwire.common.util.system.LinuxOperatingSystem;
import com.tripwire.common.util.system.OperatingSystem;
import com.tripwire.common.util.system.PariscSystemArchitecture;
import com.tripwire.common.util.system.PowerpcSystemArchitecture;
import com.tripwire.common.util.system.RedhatEl21OperatingSystem;
import com.tripwire.common.util.system.RedhatEl4OperatingSystem;
import com.tripwire.common.util.system.RedhatEl5OperatingSystem;
import com.tripwire.common.util.system.RedhatLinuxOperatingSystem;
import com.tripwire.common.util.system.SolarisOperatingSystem;
import com.tripwire.common.util.system.SparcSystemArchitecture;
import com.tripwire.common.util.system.SuseEs101LinuxOperatingSystem;
import com.tripwire.common.util.system.SuseLinuxOperatingSystem;
import com.tripwire.common.util.system.SystemArchitecture;
import com.tripwire.common.util.system.Windows2003OperatingSystem;
import com.tripwire.common.util.system.Windows2kOperatingSystem;
import com.tripwire.common.util.system.WindowsNtOperatingSystem;
import com.tripwire.common.util.system.WindowsOperatingSystem;
import com.tripwire.common.util.system.WindowsXpOperatingSystem;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class SystemUtil {
    public static final OperatingSystem AIX = new AixOperatingSystem();
    public static final OperatingSystem LINUX = new LinuxOperatingSystem();
    public static final OperatingSystem REDHAT_LINUX = new RedhatLinuxOperatingSystem();
    public static final OperatingSystem REDHAT_EL21_LINUX = new RedhatEl21OperatingSystem();
    public static final OperatingSystem REDHAT_EL4_LINUX = new RedhatEl4OperatingSystem();
    public static final OperatingSystem REDHAT_EL5_LINUX = new RedhatEl5OperatingSystem();
    public static final OperatingSystem SUSE_LINUX = new SuseLinuxOperatingSystem();
    public static final OperatingSystem SUSE_ES101_LINUX = new SuseEs101LinuxOperatingSystem();
    public static final OperatingSystem SOLARIS = new SolarisOperatingSystem();
    public static final OperatingSystem HPUX = new HpuxOperatingSystem();
    public static final OperatingSystem WINDOWS = new WindowsOperatingSystem();
    public static final OperatingSystem WINDOWS_NT = new WindowsNtOperatingSystem();
    public static final OperatingSystem WINDOWS_2000 = new Windows2kOperatingSystem();
    public static final OperatingSystem WINDOWS_XP = new WindowsXpOperatingSystem();
    public static final OperatingSystem WINDOWS_2003 = new Windows2003OperatingSystem();
    public static final OperatingSystem CURRENT_OS;
    protected static final Collection OPERATING_SYSTEMS;
    public static final SystemArchitecture X86;
    public static final SystemArchitecture IA64;
    public static final SystemArchitecture PARISC;
    public static final SystemArchitecture PPC;
    public static final SystemArchitecture SPARC;
    public static final SystemArchitecture CURRENT_ARCH;
    protected static final List ARCHITECTURES;

    public static String getFullSystemName() {
        return CURRENT_OS + "-" + CURRENT_ARCH;
    }

    public static String getFullSystemNameFor(String osName, String osArch) {
        OperatingSystem os = SystemUtil.getOsFor(osName);
        SystemArchitecture arch = SystemUtil.getArchFor(osArch);
        return os + "-" + arch;
    }

    public static OperatingSystem getOsFor(final String osName) {
        return (OperatingSystem)CollectionUtils.find(OPERATING_SYSTEMS, new Predicate(){

            public boolean evaluate(Object o) {
                return ((OperatingSystem)o).matchesOperatingSystem(osName);
            }
        });
    }

    public static SystemArchitecture getArchFor(final String osArch) {
        return (SystemArchitecture)CollectionUtils.find(ARCHITECTURES, new Predicate(){

            public boolean evaluate(Object o) {
                return ((SystemArchitecture)o).matchesArchitecture(osArch);
            }
        });
    }

    public static boolean isWindows() {
        return WINDOWS.isCurrentOperatingSystem();
    }

    public static boolean isWindowsNt() {
        return WINDOWS_NT.isCurrentOperatingSystem();
    }

    public static boolean isWindows2000() {
        return WINDOWS_2000.isCurrentOperatingSystem();
    }

    public static boolean isWindows2003() {
        return WINDOWS_2003.isCurrentOperatingSystem();
    }

    public static boolean isWindowsXp() {
        return WINDOWS_XP.isCurrentOperatingSystem();
    }

    public static boolean isSolaris() {
        return SOLARIS.isCurrentOperatingSystem();
    }

    public static boolean isSolarisX86() {
        return SOLARIS.isCurrentOperatingSystem() && X86.isCurrentArchitecture();
    }

    public static boolean isHpux() {
        return HPUX.isCurrentOperatingSystem();
    }

    public static boolean isHpuxIa64() {
        return HPUX.isCurrentOperatingSystem() && IA64.isCurrentArchitecture();
    }

    public static boolean isAix() {
        return AIX.isCurrentOperatingSystem();
    }

    public static boolean isLinux() {
        return LINUX.isCurrentOperatingSystem();
    }

    public static boolean isRedHatEL21() {
        return REDHAT_EL21_LINUX.isCurrentOperatingSystem();
    }

    public static boolean isRedHatEL4() {
        return REDHAT_EL4_LINUX.isCurrentOperatingSystem();
    }

    public static boolean isRedHatEL5() {
        return REDHAT_EL5_LINUX.isCurrentOperatingSystem();
    }

    public static synchronized boolean isSuseES101() {
        return SUSE_ES101_LINUX.isCurrentOperatingSystem();
    }

    public static boolean isPosix() {
        return !SystemUtil.isWindows();
    }

    public static String getLocalHost() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return host;
    }

    public static String[] getAllHostNames(String hostname) {
        String[] names = null;
        try {
            InetAddress[] addrs = InetAddress.getAllByName(hostname);
            names = new String[addrs.length];
            for (int i = 0; i < addrs.length; ++i) {
                InetAddress addr = addrs[i];
                names[i] = addr.getCanonicalHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return names;
    }

    static {
        OPERATING_SYSTEMS = new ArrayList();
        X86 = new Ia32SystemArchitecture();
        IA64 = new Ia64SystemArchitecture();
        PARISC = new PariscSystemArchitecture();
        PPC = new PowerpcSystemArchitecture();
        SPARC = new SparcSystemArchitecture();
        ARCHITECTURES = new ArrayList();
        OPERATING_SYSTEMS.add(AIX);
        OPERATING_SYSTEMS.add(REDHAT_EL21_LINUX);
        OPERATING_SYSTEMS.add(REDHAT_EL4_LINUX);
        OPERATING_SYSTEMS.add(REDHAT_EL5_LINUX);
        OPERATING_SYSTEMS.add(SUSE_ES101_LINUX);
        OPERATING_SYSTEMS.add(SOLARIS);
        OPERATING_SYSTEMS.add(HPUX);
        OPERATING_SYSTEMS.add(WINDOWS_NT);
        OPERATING_SYSTEMS.add(WINDOWS_2000);
        OPERATING_SYSTEMS.add(WINDOWS_2003);
        OPERATING_SYSTEMS.add(WINDOWS_XP);
        OPERATING_SYSTEMS.add(LINUX);
        OPERATING_SYSTEMS.add(WINDOWS);
        CURRENT_OS = SystemUtil.getOsFor(System.getProperty("os.name"));
        ARCHITECTURES.add(X86);
        ARCHITECTURES.add(IA64);
        ARCHITECTURES.add(PARISC);
        ARCHITECTURES.add(PPC);
        ARCHITECTURES.add(SPARC);
        CURRENT_ARCH = SystemUtil.getArchFor(System.getProperty("os.arch"));
    }
}

