/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ClassLoaderUtil {
    private static final URLWalker DEFAULT_URLWALKER = new URLWalker();
    private static final URL[] EMPTY_URLS = new URL[0];

    public static Class forName(Class caller, String classname) throws ClassNotFoundException {
        return ClassLoaderUtil.getClassLoader(caller).loadClass(classname);
    }

    public static ClassLoader getClassLoader(Class caller) {
        ClassLoader systemLoader;
        ClassLoader callerLoader = caller.getClassLoader();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader result = ClassLoaderUtil.isChild(contextLoader, callerLoader) ? callerLoader : (ClassLoaderUtil.isChild(callerLoader, contextLoader) ? contextLoader : contextLoader);
        if (ClassLoaderUtil.isChild(result, systemLoader = ClassLoader.getSystemClassLoader())) {
            result = systemLoader;
        }
        return result;
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == loader2) {
            return true;
        }
        if (loader2 == null) {
            return false;
        }
        if (loader1 == null) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }

    public static String calculateAnnotation(URL[] urls) {
        Object[] entries = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            entries[i] = urls[i].toExternalForm();
        }
        Arrays.sort(entries);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < entries.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append((String)entries[i]);
        }
        return buf.toString();
    }

    public static Set extractURLs(ClassLoader loader) {
        return ClassLoaderUtil.extractURLs(loader, null);
    }

    public static Set extractURLs(ClassLoader loader, URLWalker walker) {
        HashSet urls = new HashSet();
        ClassLoaderUtil.extractURLs(urls, loader, walker);
        return urls;
    }

    public static void extractURLs(Set urls, ClassLoader loader, URLWalker walker) {
        assert (urls != null);
        if (walker == null) {
            walker = DEFAULT_URLWALKER;
        }
        while (loader != null) {
            if (loader == ClassLoader.getSystemClassLoader()) {
                ClassLoaderUtil.recurseSystemClasspath(urls, walker);
                return;
            }
            if (loader instanceof URLClassLoader) {
                ClassLoaderUtil.recurseURLClassLoader(urls, (URLClassLoader)loader, walker);
            }
            loader = loader.getParent();
        }
    }

    private static void recurseSystemClasspath(Set urls, URLWalker walker) {
        String cp = System.getProperty("java.class.path");
        StringTokenizer toker = new StringTokenizer(cp, File.pathSeparator);
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            File file = new File(token);
            if (!file.exists()) continue;
            try {
                ClassLoaderUtil.addURLAndDependencies(urls, file.toURI().toURL(), walker);
            }
            catch (MalformedURLException e) {}
        }
    }

    private static void recurseURLClassLoader(Set urls, URLClassLoader loader, URLWalker walker) {
        URL[] urlArray = loader.getURLs();
        for (int i = 0; i < urlArray.length; ++i) {
            ClassLoaderUtil.addURLAndDependencies(urls, urlArray[i], walker);
        }
    }

    private static void addURLAndDependencies(Set urls, URL url, URLWalker walker) {
        if (!urls.add(url)) {
            return;
        }
        Attributes attrs = ClassLoaderUtil.getManifestClassPath(url);
        if (!walker.visit(url, attrs)) {
            return;
        }
        if (attrs == null) {
            return;
        }
        String classpath = attrs.getValue("Class-Path");
        if (classpath == null) {
            return;
        }
        StringTokenizer toker = new StringTokenizer(classpath, " ");
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            try {
                URI originalUri = new URI(url.toExternalForm());
                URI newUri = originalUri.resolve(token);
                ClassLoaderUtil.addURLAndDependencies(urls, newUri.toURL(), walker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getManifestClassPath(URL url) {
        if (url.toExternalForm().endsWith("/")) {
            return null;
        }
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(url.openStream());
            Manifest mf = jis.getManifest();
            if (mf != null) {
                Attributes attributes = mf.getMainAttributes();
                return attributes;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    public static URL getClassSource(Class c) {
        String classResource = c.getName().replace('.', '/') + ".class";
        return ClassLoaderUtil.getResourceSource(c.getClassLoader(), classResource);
    }

    public static File getClassSourceFile(Class c) {
        String classResource = c.getName().replace('.', '/') + ".class";
        return ClassLoaderUtil.getResourceSourceFile(c.getClassLoader(), classResource);
    }

    public static String getEmbeddedUrlFromJarUrl(String url) {
        String retval = url;
        if (url != null && retval.startsWith("jar:")) {
            int pling = retval.indexOf("!");
            retval = retval.substring(4, pling);
        }
        return retval;
    }

    public static URL getResourceSource(ClassLoader c, String resource) {
        if (c == null) {
            c = ClassLoaderUtil.class.getClassLoader();
        }
        URL url = null;
        url = c == null ? ClassLoader.getSystemResource(resource) : c.getResource(resource);
        return url;
    }

    public static File getResourceSourceFile(ClassLoader c, String resource) {
        URL url = ClassLoaderUtil.getResourceSource(c, resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(4, pling);
                return new File(ClassLoaderUtil.fromURI(jarName));
            }
            if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(0, tail);
                return new File(ClassLoaderUtil.fromURI(dirName));
            }
        }
        return null;
    }

    public static String fromURI(String uri) {
        String file;
        int queryPos;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException emYouEarlEx) {
            // empty catch block
        }
        if (url == null || !"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Can only handle valid file: URIs");
        }
        StringBuffer buf = new StringBuffer(url.getHost());
        if (buf.length() > 0) {
            buf.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        buf.append((queryPos = (file = url.getFile()).indexOf(63)) < 0 ? file : file.substring(0, queryPos));
        uri = buf.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        String path = ClassLoaderUtil.decodeUri(uri);
        return path;
    }

    private static String decodeUri(String uri) {
        if (uri.indexOf(37) == -1) {
            return uri;
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        String path = sb.toString();
        return path;
    }

    public static URL[] getLocationURLs(File location) throws MalformedURLException {
        return ClassLoaderUtil.getLocationURLs(location, new String[]{".jar"});
    }

    public static URL[] getLocationURLs(File location, final String[] extensions) throws MalformedURLException {
        if (!location.exists()) {
            return EMPTY_URLS;
        }
        if (!location.isDirectory()) {
            URL[] urls = new URL[1];
            String path = location.getPath();
            for (int i = 0; i < extensions.length; ++i) {
                if (!path.toLowerCase().endsWith(extensions[i])) continue;
                urls[0] = location.toURL();
                break;
            }
            return urls;
        }
        File[] matches = location.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                for (int i = 0; i < extensions.length; ++i) {
                    if (!name.toLowerCase().endsWith(extensions[i])) continue;
                    return true;
                }
                return false;
            }
        });
        int N = matches.length;
        URL[] urls = new URL[N];
        for (int i = 0; i < N; ++i) {
            urls[i] = matches[i].toURL();
        }
        return urls;
    }

    public static class URLWalker {
        public boolean visit(URL url, Attributes attributes) {
            return true;
        }
    }
}

