/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.util.SharedByteArrayInputStream;
import com.tripwire.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;

public class StreamUtil {
    public static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF16_LE = new byte[]{-1, -2};
    public static final byte[] BOM_UTF16_BE = new byte[]{-2, -1};
    private static final int READ_BUFFER_LENGTH = 8192;

    public static void close(InputStream stream) {
        StreamUtil.close(stream, false);
    }

    public static void close(InputStream stream, boolean silent) {
        block3: {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void flush(OutputStream stream) {
        StreamUtil.flush(stream, false);
    }

    public static void flush(OutputStream stream, boolean silent) {
        block3: {
            try {
                if (stream != null) {
                    stream.flush();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void close(OutputStream stream) {
        StreamUtil.close(stream, false);
    }

    public static void close(OutputStream stream, boolean silent) {
        block3: {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void flush(Writer writer) {
        StreamUtil.flush(writer, false);
    }

    public static void flush(Writer writer, boolean silent) {
        block3: {
            try {
                if (writer != null) {
                    writer.flush();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void close(Writer writer) {
        StreamUtil.close(writer, false);
    }

    public static void close(Writer writer, boolean silent) {
        block3: {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void close(Reader reader, boolean silent) {
        block3: {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                if (silent) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void close(Reader reader) {
        StreamUtil.close(reader, false);
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        int read;
        Reader from = reader instanceof BufferedReader || reader instanceof CharArrayReader || reader instanceof StringReader ? reader : new BufferedReader(reader);
        Writer to = writer instanceof BufferedWriter || writer instanceof CharArrayWriter || writer instanceof StringWriter ? writer : new BufferedWriter(writer);
        long total = 0L;
        char[] cbuf = new char[8192];
        while ((read = from.read(cbuf)) != -1) {
            total += (long)read;
            to.write(cbuf, 0, read);
        }
        to.flush();
        return total;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        if (input instanceof SharedByteArrayInputStream) {
            return StreamUtil.copy((SharedByteArrayInputStream)input, output);
        }
        return StreamUtil.copy(input, output, new byte[8192]);
    }

    public static int copy(SharedByteArrayInputStream input, OutputStream output) throws IOException {
        int size = input.size();
        output.write(input.referenceByteArray(), input.getStart(), size);
        return size;
    }

    public static int copy(InputStream input, OutputStream output, int bytesToCopy) throws IOException {
        return StreamUtil.copy(input, output, bytesToCopy, new byte[bytesToCopy > 0 && bytesToCopy < 8192 ? bytesToCopy : 8192]);
    }

    public static int copy(InputStream input, OutputStream output, int bytesToCopy, byte[] readBuffer) throws IOException {
        int bytesToRead;
        int bytesReadThisRound;
        if (bytesToCopy == -1) {
            return StreamUtil.copy(input, output, readBuffer);
        }
        int totalBytesRead = 0;
        int bufferLength = readBuffer.length;
        for (int bytesLeftToCopy = bytesToCopy; bytesLeftToCopy > 0 && (bytesReadThisRound = input.read(readBuffer, 0, bytesToRead = bufferLength < bytesLeftToCopy ? bufferLength : bytesLeftToCopy)) != -1; bytesLeftToCopy -= bytesReadThisRound) {
            output.write(readBuffer, 0, bytesReadThisRound);
            totalBytesRead += bytesReadThisRound;
        }
        return totalBytesRead;
    }

    public static int copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int read;
        int size = buffer.length;
        int written = 0;
        while ((read = input.read(buffer, 0, size)) != -1) {
            output.write(buffer, 0, read);
            written += read;
        }
        return written;
    }

    public static int read(InputStream input, byte[] buffer) throws IOException {
        return StreamUtil.read(input, buffer, 0, buffer.length);
    }

    public static int read(InputStream input, byte[] buffer, int offset, int bytesToRead) throws IOException {
        int totalBytesRead;
        int bytesRead;
        for (totalBytesRead = 0; totalBytesRead < bytesToRead && (bytesRead = input.read(buffer, offset + totalBytesRead, bytesToRead - totalBytesRead)) != -1; totalBytesRead += bytesRead) {
        }
        return totalBytesRead;
    }

    public static SharedByteArrayInputStream getInputStream(String data) {
        try {
            return new SharedByteArrayInputStream(data.getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static SharedByteArrayInputStream getInputStreamDefaultEncoding(String data) {
        return new SharedByteArrayInputStream(data.getBytes());
    }

    public static String getString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        StreamUtil.copy(reader, writer);
        return writer.toString();
    }

    public static String getString(InputStream in) throws IOException {
        if (in instanceof SharedByteArrayInputStream) {
            return StreamUtil.getString((SharedByteArrayInputStream)in);
        }
        return new String(StreamUtil.getBytes(in));
    }

    public static String getString(InputStream in, String encoding) throws IOException {
        if (in instanceof SharedByteArrayInputStream) {
            return StreamUtil.getString((SharedByteArrayInputStream)in, encoding);
        }
        return new String(StreamUtil.getBytes(in), encoding);
    }

    public static String getString(SharedByteArrayInputStream in) throws IOException {
        return new String(in.referenceByteArray(), in.getStart(), in.size());
    }

    public static String getString(SharedByteArrayInputStream in, String encoding) throws IOException {
        return new String(in.referenceByteArray(), in.getStart(), in.size(), encoding);
    }

    public static String[] getLines(InputStream in) throws IOException {
        String s = StreamUtil.getString(in);
        return StringUtil.splitStringEOL(s);
    }

    public static String[] getLines(InputStream in, String encoding) throws IOException {
        String s = StreamUtil.getString(in, encoding);
        return StringUtil.splitStringEOL(s);
    }

    public static boolean equals(InputStream lhs, InputStream rhs) throws IOException {
        byte[] lhsReadBuffer = new byte[8192];
        byte[] rhsReadBuffer = new byte[8192];
        do {
            int rhsRead;
            int lhsRead;
            if ((lhsRead = StreamUtil.read(lhs, lhsReadBuffer)) != (rhsRead = StreamUtil.read(rhs, rhsReadBuffer))) {
                return false;
            }
            if (lhsRead == 0) {
                return true;
            }
            if (lhsRead >= 8192) continue;
            Arrays.fill(lhsReadBuffer, lhsRead, 8192, (byte)0);
            Arrays.fill(rhsReadBuffer, rhsRead, 8192, (byte)0);
        } while (Arrays.equals(lhsReadBuffer, rhsReadBuffer));
        return false;
    }

    public static int hashCode(InputStream inputStream) throws IOException {
        int bytesRead;
        int hashCode = 1;
        byte[] readBuffer = new byte[8192];
        while ((bytesRead = inputStream.read(readBuffer)) >= 0) {
            for (int i = 0; i < bytesRead; ++i) {
                hashCode = 31 * hashCode + readBuffer[i];
            }
        }
        return hashCode;
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        int sz = in.available();
        if (sz < 0) {
            return new byte[0];
        }
        byte[] buf = new byte[sz];
        int read = in.read(buf, 0, sz);
        int next = in.read();
        if (read == -1 || next == -1 && read == sz) {
            return buf;
        }
        int size = sz < 256 ? 256 : sz;
        ByteArrayOutputStream out = new ByteArrayOutputStream(size * 2);
        out.write(buf);
        out.write(next);
        if (sz < size) {
            buf = new byte[size];
        }
        while ((read = in.read(buf, 0, size)) > 0) {
            out.write(buf, 0, read);
        }
        return out.toByteArray();
    }

    public static BufferedWriter getWriterUtf8(File f) throws FileNotFoundException, UnsupportedEncodingException {
        return StreamUtil.getWriter(f, "UTF-8");
    }

    public static BufferedWriter getWriterUtf8(OutputStream stream) throws UnsupportedEncodingException {
        return StreamUtil.getWriter(stream, "UTF-8");
    }

    public static BufferedWriter getWriter(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return StreamUtil.getWriter(new FileOutputStream(file), charEncoding);
    }

    public static BufferedWriter getWriter(OutputStream stream, String charEncoding) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(stream, charEncoding));
    }

    public static IOException asIOException(Throwable e) {
        return e instanceof IOException ? (IOException)e : (IOException)new IOException(e.getMessage()).initCause(e);
    }

    public static String readUTF(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        int utflen = (ch1 << 8) + ch2;
        char[] str = new char[utflen];
        byte[] bytearr = new byte[utflen];
        int count = 0;
        int pos = 0;
        StreamUtil.read(in, bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[pos++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[pos++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[pos++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, pos);
    }

    public static int writeUTF(OutputStream out, String str) throws IOException, UTFDataFormatException {
        int strlen = str.length();
        char[] chars = new char[strlen];
        str.getChars(0, strlen, chars, 0);
        byte[] bytearr = new byte[strlen * 3 + 2];
        int index = 2;
        for (int i = 0; i < strlen; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[index++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[index++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytearr[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[index++] = (byte)(0x80 | c & 0x3F);
        }
        int utfByteLen = index - 2;
        if (utfByteLen > 65535) {
            throw new UTFDataFormatException();
        }
        bytearr[0] = (byte)(utfByteLen >>> 8 & 0xFF);
        bytearr[1] = (byte)(utfByteLen & 0xFF);
        out.write(bytearr, 0, index);
        return index;
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v & 0xFF);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((byte)(v >>> 56));
        out.write((byte)(v >>> 48));
        out.write((byte)(v >>> 40));
        out.write((byte)(v >>> 32));
        out.write((byte)(v >>> 24));
        out.write((byte)(v >>> 16));
        out.write((byte)(v >>> 8));
        out.write((byte)v);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] readBuffer = new byte[8];
        StreamUtil.read(in, readBuffer, 0, 8);
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)(readBuffer[7] & 0xFF);
    }

    public static void writeOptionalUTF(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(s);
        }
    }

    public static String readOptionalUTF(ObjectInput in) throws IOException {
        boolean isNull = in.readByte() == 0;
        return isNull ? null : in.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String guessEncoding(InputStream in) throws IOException {
        if (!in.markSupported()) {
            return null;
        }
        in.mark(3);
        try {
            String encoding = null;
            byte b = (byte)in.read();
            if (b == BOM_UTF8[0]) {
                if ((byte)in.read() == BOM_UTF8[1] && (byte)in.read() == BOM_UTF8[2]) {
                    encoding = "UTF8";
                }
            } else if (b == BOM_UTF16_LE[0]) {
                if ((byte)in.read() == BOM_UTF16_LE[1]) {
                    encoding = "UTF-16";
                }
            } else if (b == BOM_UTF16_BE[0] && (byte)in.read() == BOM_UTF16_BE[1]) {
                encoding = "UTF-16";
            }
            String string = encoding;
            return string;
        }
        finally {
            in.reset();
        }
    }
}

