/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.app.xml.parser;

import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.RulesRef;
import com.tripwire.common.util.xml.AbstractXmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.BasicConditionalVisitor;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ConditionalPredicate;
import com.tripwire.space.core.conditional.ContentConditions;
import com.tripwire.space.core.conditional.xml.ConditionXmlParser;
import java.io.IOException;

public class ContentTestParser
extends AbstractXmlElementParser {
    public ContentTestParser() {
        super(CONTENT_TEST_ELEMENT, ContentTest.class);
    }

    public void readAttributes(XmlInputContext in, Object obj) throws XmlException {
        ContentTest contentTest = (ContentTest)obj;
        String attrib = in.getStringAttribute(ID_ATTRIBUTE);
        contentTest.setAttribId(attrib);
        attrib = in.getStringAttribute(CLASS_ATTRIBUTE);
        contentTest.setAttribClass(attrib);
        attrib = in.getStringAttribute(NAME_ATTRIBUTE);
        contentTest.setAttribName(attrib);
        attrib = in.getStringAttribute(EXTERNAL_ID_ATTRIBUTE);
        contentTest.setAttribExternalId(attrib);
        boolean battrib = in.attributeExists(DISPLAYABLE_ELEMENT_OUTPUT_ATTRIBUTE) ? in.getBooleanAttribute(DISPLAYABLE_ELEMENT_OUTPUT_ATTRIBUTE) : false;
        contentTest.setAttribDisplayableElementOutput(battrib);
    }

    public void readBody(XmlInputContext in, Object object) throws XmlException, IOException {
        final ContentTest contentTest = (ContentTest)object;
        contentTest.setDescription(this.parseDescription(in));
        while (in.detectElementStart(OBJECT_ACL_ELEMENT) || in.detectElementStart(SEVERITY_ELEMENT) || in.detectElementStart(EXCLUDED_NODES_ELEMENT) || in.detectElementStart(REMEDIATION_INSTRUCTIONS_ELEMENT)) {
            in.skipNextElement();
        }
        ConditionXmlParser.Proxy proxy = (ConditionXmlParser.Proxy)in.maybeParseObjectElement();
        Conditional conditional = proxy.getConditional();
        try {
            conditional.accept(new BasicConditionalVisitor(){

                public boolean visit(ConditionalPredicate cond) throws SpaceException {
                    String elemName = cond.getRhsOperand().toString().trim();
                    elemName = elemName.replaceAll("\n", " ");
                    elemName = elemName.replaceAll("  +", " ");
                    contentTest.setElementName(elemName);
                    return true;
                }
            });
        }
        catch (SpaceException e) {
            throw new RuntimeException(e);
        }
        proxy = (ConditionXmlParser.Proxy)in.maybeParseObjectElement();
        contentTest.setContentConditional((ContentConditions)proxy.getConditions());
        if (in.detectElementStart(NODE_INCLUSION_COND_ELEMENT)) {
            in.skipNextElement();
        }
        if (in.detectElementStart(RULES_REF_ELEMENT)) {
            contentTest.setRulesRef((RulesRef)in.maybeParseObjectElement());
        }
    }
}

