/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.app;

import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.app.Test;
import com.tripwire.checker.app.TestResultType;
import com.tripwire.checker.app.xml.Child;
import com.tripwire.checker.app.xml.Children;
import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.PolicyTest;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.util.StringUtil;
import com.tripwire.vmware.api.EsxServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineListener
implements ConfigCheckerListener {
    public static final String ROOT_GROUP_ID = "ID0";
    private Map<TestResultType, Integer> m_resultCounts = new ConcurrentHashMap<TestResultType, Integer>();
    private Map<ContentTest, TestResultType> m_results = new HashMap<ContentTest, TestResultType>();
    private HashMap<String, PolicyTest> m_tests;
    private HashMap<String, PolicyTest> check;

    private void inc(TestResultType curVal, int val) {
        int oldCount = this.getResultCounts().containsKey((Object)curVal) ? this.getResultCounts().get((Object)curVal) : 0;
        this.getResultCounts().put(curVal, oldCount + val);
    }

    public int printPolicyStructure(HashMap<String, PolicyTest> tests, PolicyTest policyTest, int level) {
        int count = 0;
        System.out.print(StringUtil.repeatCharacter('\t', level));
        System.out.print(policyTest.getAttribId());
        System.out.print(", ");
        System.out.print(policyTest.getAttribName());
        System.out.print(", ");
        System.out.print(policyTest.getDescription());
        System.out.println();
        ++count;
        this.check.remove(policyTest.getAttribId());
        Children children = policyTest.getChildren();
        if (null != children) {
            List<Child> childs = children.getChildren();
            if (null != childs) {
                for (Child child : childs) {
                    PolicyTest newPolicyTest = tests.get(child.getAttribRefid());
                    if (null == newPolicyTest) continue;
                    count += this.printPolicyStructure(tests, newPolicyTest, level + 1);
                }
            }
        } else {
            TestResultType testResult;
            String elementContent;
            String string = elementContent = policyTest.isAttribDisplayableElementOutput() ? policyTest.getElementContent() : "";
            if (StringUtil.notEmpty(elementContent)) {
                System.out.print(StringUtil.repeatCharacter('\t', level + 1));
                System.out.println(elementContent);
            }
            if (null != (testResult = this.getResults().get(policyTest))) {
                System.out.print(StringUtil.repeatCharacter('\t', level + 1));
                System.out.println(testResult.getName());
            }
        }
        return count;
    }

    @Override
    public void onTestsLoaded(HashMap<String, PolicyTest> tests) {
        System.out.println("\n\nonTestsLoaded: Top Down Structure");
        this.setTests(tests);
        for (String key : tests.keySet()) {
            PolicyTest policyTest = tests.get(key);
            if (!(policyTest instanceof ContentTest)) continue;
            this.inc(TestResultType.UNKNOWN, 1);
        }
        this.printPolicyStructure(tests);
    }

    private void printPolicyStructure(HashMap<String, PolicyTest> tests) {
        if (null == tests) {
            return;
        }
        this.check = new HashMap();
        this.check.putAll(tests);
        PolicyTest newPolicyTest = tests.get(ROOT_GROUP_ID);
        if (null != newPolicyTest) {
            int count = this.printPolicyStructure(tests, newPolicyTest, 0);
            System.out.println("Printed " + count + " tests of " + tests.size());
        }
        for (String key : this.check.keySet()) {
            PolicyTest policyTest = this.check.get(key);
            System.out.println("missing: key=" + key + ";name=" + policyTest.getAttribName());
        }
    }

    @Override
    public void onStart(String policyFile) {
        for (TestResultType curType : TestResultType.values()) {
            this.getResultCounts().put(curType, 0);
        }
        this.getResults().clear();
        HashMap<String, PolicyTest> tests = this.getTests();
        if (null != tests) {
            tests.clear();
        }
        System.out.println("Starting " + policyFile);
    }

    public void printSummaryCount() {
        for (TestResultType curResult : this.getResultCounts().keySet()) {
            System.out.print("\t");
            System.out.print(curResult.getName());
            System.out.print("=");
            System.out.print(this.getResultCounts().get((Object)curResult));
            System.out.print(" ");
        }
        System.out.println();
    }

    @Override
    public void onChangeTest(ContentTest test, TestResultType newResult, TestResultType oldResult) {
        this.getResults().put(test, newResult);
        this.inc(oldResult, -1);
        this.inc(newResult, 1);
        this.printSummaryCount();
    }

    @Override
    public void onTestError(Test test, CheckerException error) {
        if (null != error) {
            System.out.println("Test error: test=" + test.getName() + ";addendum=" + error.getAddendum() + ";cause=" + error.getCause() + ";localizedMessage=" + error.getLocalizedMessage() + ";logMessage=" + error.getLogMessage() + ";message=" + error.getMessage());
        }
    }

    @Override
    public void onFatalError(CheckerException error) {
    }

    @Override
    public void onGeneralError(CheckerException error) {
    }

    @Override
    public void onVersionInfo(String uname, String vmware, EsxServer.Version version) {
        String fullName;
        if (null != uname && uname.length() > 0) {
            System.out.println("OnVersionInfo: uname=" + uname.trim() + " ***");
        }
        if (null != vmware && vmware.length() > 0) {
            System.out.println("OnVersionInfo: *** vmware=" + vmware.trim() + " ***");
        }
        if (null != version && null != (fullName = version.getFullName()) && fullName.length() > 0) {
            System.out.println("OnVersionInfo: *** fullname=" + fullName + " ***");
        }
    }

    @Override
    public void onAccessorStart(String accessorType) {
        System.out.println("Accessor Start: " + accessorType);
    }

    @Override
    public void onAccessorChange(String accessorType, AccessorResultType newResult, AccessorResultType oldResult) {
        System.out.println("Accessor Change: " + accessorType + " - to " + newResult.getName() + " from " + oldResult.getName());
    }

    @Override
    public void onAccessorEnd(String accessorType, long timeTaken, AccessorResultType result, Exception e) {
        System.out.println("Accessor End: " + accessorType + " - time: " + timeTaken + " ms, result=" + result.getName() + (e == null ? "" : ", e=" + e));
        this.printSummaryCount();
        System.out.println("\t" + ElementCache.getInstance().getInfo(false, false));
    }

    @Override
    public void onEnd(long timeTaken) {
        this.printPolicyStructure(this.getTests());
        System.out.println("DONE " + timeTaken + " ms");
        this.printSummaryCount();
        System.out.println("\t" + ElementCache.getInstance().getInfo(false, false));
    }

    public Map<TestResultType, Integer> getResultCounts() {
        return this.m_resultCounts;
    }

    public void setResultCounts(Map<TestResultType, Integer> resultCounts) {
        this.m_resultCounts = resultCounts;
    }

    public Map<ContentTest, TestResultType> getResults() {
        return this.m_results;
    }

    public void setResults(Map<ContentTest, TestResultType> results) {
        this.m_results = results;
    }

    public HashMap<String, PolicyTest> getTests() {
        return this.m_tests;
    }

    public void setTests(HashMap<String, PolicyTest> tests) {
        this.m_tests = tests;
    }
}

