/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ResourceAllocationInfo;
import com.vmware.vim25.ResourceConfigSpec;
import java.util.Calendar;

public class ResourceConfigSpecCollector
extends AbstractVmwareCollector {
    public ResourceConfigSpecCollector() {
        super(ResourceConfigSpec.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".ResourceConfigSpec";
        if (o instanceof ResourceConfigSpec) {
            ResourceConfigSpec resourceConfigSpec = (ResourceConfigSpec)o;
            String changeVersion = resourceConfigSpec.getChangeVersion();
            this.doPut(curKey + ".ChangeVersion", changeVersion);
            ResourceAllocationInfo cpuAllocation = resourceConfigSpec.getCpuAllocation();
            this.doCollect(cpuAllocation, curKey);
            ManagedObjectReference entity = resourceConfigSpec.getEntity();
            this.doCollect(entity, curKey);
            Calendar lastModified = resourceConfigSpec.getLastModified();
            if (null != lastModified) {
                this.doPut(curKey + ".lastModified", lastModified.getTime().toString());
            }
            ResourceAllocationInfo memoryAllocation = resourceConfigSpec.getMemoryAllocation();
            this.doCollect(memoryAllocation, curKey);
        }
    }
}

