/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostNetworkPolicy;
import com.vmware.vim25.HostVirtualSwitchBridge;
import com.vmware.vim25.HostVirtualSwitchSpec;

public class HostVirtualSwitchSpecCollector
extends AbstractVmwareCollector {
    public HostVirtualSwitchSpecCollector() {
        super(HostVirtualSwitchSpec.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostVirtualSwitch";
        if (o instanceof HostVirtualSwitchSpec) {
            HostVirtualSwitchSpec hostVirtualSwitchSpec = (HostVirtualSwitchSpec)o;
            HostVirtualSwitchBridge bridge = hostVirtualSwitchSpec.getBridge();
            this.doCollect(bridge, curKey);
            Integer mtu = hostVirtualSwitchSpec.getMtu();
            if (null != mtu) {
                this.doPut(curKey + ".Mtu", "" + mtu);
            }
            int numPorts = hostVirtualSwitchSpec.getNumPorts();
            this.doPut(curKey + ".NumPorts", "" + numPorts);
            HostNetworkPolicy policy = hostVirtualSwitchSpec.getPolicy();
            this.doCollect(policy, curKey);
        }
    }
}

