/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HealthSystemRuntime;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.HostSystemPowerState;
import java.util.Calendar;

public class HostRuntimeInfoCollector
extends AbstractVmwareCollector {
    public HostRuntimeInfoCollector() {
        super(HostRuntimeInfo.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostRuntimeInfo";
        if (o instanceof HostRuntimeInfo) {
            HostRuntimeInfo hostRuntimeInfo = (HostRuntimeInfo)o;
            Calendar bootTime = hostRuntimeInfo.getBootTime();
            if (null != bootTime) {
                this.doPut(curKey + ".BootTime", bootTime.getTime().toString());
            }
            HostSystemConnectionState connectionState = hostRuntimeInfo.getConnectionState();
            this.doCollect(connectionState, curKey);
            HealthSystemRuntime healthSystemRuntime = hostRuntimeInfo.getHealthSystemRuntime();
            this.doCollect(healthSystemRuntime, curKey);
            HostSystemPowerState powerState = hostRuntimeInfo.getPowerState();
            this.doCollect(powerState, curKey);
            boolean maintenanceMode = hostRuntimeInfo.isInMaintenanceMode();
            this.doPut(curKey + ".MaintenanceMode", "" + maintenanceMode);
        }
    }
}

